/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateUser;
import io.crate.auth.user.UserManager;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.user.SecureHash;
import io.crate.user.UserActions;

public class CreateUserPlan
implements Plan {
    private final AnalyzedCreateUser createUser;
    private final UserManager userManager;

    public CreateUserPlan(AnalyzedCreateUser createUser, UserManager userManager) {
        this.createUser = createUser;
        this.userManager = userManager;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        SecureHash newPassword = UserActions.generateSecureHash(this.createUser.properties(), params, plannerContext.transactionContext(), plannerContext.nodeContext());
        this.userManager.createUser(this.createUser.userName(), newPassword).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }
}

