/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedColumnDefinition;
import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.BoundCreateTable;
import io.crate.analyze.NumberOfShards;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableParameter;
import io.crate.analyze.TableParameters;
import io.crate.analyze.TablePropertiesAnalyzer;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.ddl.tables.TableCreator;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.PartitionedBy;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Settings;

public class CreateTablePlan
implements Plan {
    private static final String CLUSTERED_BY_IN_PARTITIONED_ERROR = "Cannot use CLUSTERED BY column in PARTITIONED BY clause";
    private final AnalyzedCreateTable createTable;
    private final NumberOfShards numberOfShards;
    private final TableCreator tableCreator;
    private final Schemas schemas;

    public CreateTablePlan(AnalyzedCreateTable createTable, NumberOfShards numberOfShards, TableCreator tableCreator, Schemas schemas) {
        this.createTable = createTable;
        this.numberOfShards = numberOfShards;
        this.tableCreator = tableCreator;
        this.schemas = schemas;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        BoundCreateTable boundCreateTable = CreateTablePlan.bind(this.createTable, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults, this.numberOfShards, this.schemas, dependencies.fulltextAnalyzerResolver());
        if (boundCreateTable.noOp()) {
            consumer.accept(InMemoryBatchIterator.empty(SentinelRow.SENTINEL), null);
            return;
        }
        this.tableCreator.create(boundCreateTable).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }

    @VisibleForTesting
    public static BoundCreateTable bind(AnalyzedCreateTable createTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults, NumberOfShards numberOfShards, Schemas schemas, FulltextAnalyzerResolver fulltextAnalyzerResolver) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, params, subQueryResults);
        CreateTable<Symbol> table = createTable.createTable();
        RelationName relationName = createTable.relationName();
        GenericProperties<Object> properties = table.properties().map(eval);
        TableParameter tableParameter = new TableParameter();
        TablePropertiesAnalyzer.analyzeWithBoundValues(tableParameter, TableParameters.TABLE_CREATE_PARAMETER_INFO, properties, true);
        AnalyzedTableElements<Object> tableElements = createTable.analyzedTableElements().map(eval);
        AnalyzedTableElements<Symbol> tableElementsWithExpressions = createTable.analyzedTableElementsWithExpressions().map(x -> SubQueryAndParamBinder.convert(x, params, subQueryResults));
        AnalyzedTableElements.finalizeAndValidate(relationName, tableElementsWithExpressions, tableElements);
        Settings tableSettings = AnalyzedTableElements.validateAndBuildSettings(tableElements, fulltextAnalyzerResolver);
        tableParameter.settingsBuilder().put(tableSettings);
        tableParameter.settingsBuilder().put("index.number_of_shards", numberOfShards.defaultNumberOfShards());
        ColumnIdent routingColumn = null;
        if (table.clusteredBy().isPresent()) {
            Optional<ClusteredBy> clusteredByOptional = table.clusteredBy().map(x -> x.map(eval));
            ClusteredBy clusteredBy = clusteredByOptional.get();
            routingColumn = CreateTablePlan.resolveRoutingFromClusteredBy(clusteredBy, tableElements);
            if (clusteredBy.numberOfShards().isPresent()) {
                tableParameter.settingsBuilder().put("index.number_of_shards", numberOfShards.fromClusteredByClause(clusteredBy));
            }
        }
        ColumnIdent finalRouting = routingColumn;
        Optional<PartitionedBy> partitionedByOptional = table.partitionedBy().map(x -> x.map(eval));
        partitionedByOptional.ifPresent(partitionedBy -> CreateTablePlan.processPartitionedBy((PartitionedBy)partitionedByOptional.get(), tableElements, relationName, finalRouting));
        return new BoundCreateTable(relationName, tableElements, tableParameter, routingColumn, table.ifNotExists(), schemas);
    }

    private static ColumnIdent resolveRoutingFromClusteredBy(ClusteredBy<Object> clusteredBy, AnalyzedTableElements<Object> tableElements) {
        if (clusteredBy.column().isPresent()) {
            Object routingColumnValue = clusteredBy.column().get();
            assert (routingColumnValue instanceof String);
            ColumnIdent routingColumn = ColumnIdent.fromPath((String)routingColumnValue);
            for (AnalyzedColumnDefinition column : tableElements.partitionedByColumns) {
                if (!column.ident().equals(routingColumn)) continue;
                throw new IllegalArgumentException(CLUSTERED_BY_IN_PARTITIONED_ERROR);
            }
            if (!CreateTablePlan.hasColumnDefinition(tableElements, routingColumn)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid or non-existent routing column \"%s\"", routingColumn));
            }
            if (AnalyzedTableElements.primaryKeys(tableElements).size() > 0 && !AnalyzedTableElements.primaryKeys(tableElements).contains(routingColumn.fqn())) {
                throw new IllegalArgumentException("Clustered by column must be part of primary keys");
            }
            if (!routingColumn.name().equalsIgnoreCase("_id")) {
                return routingColumn;
            }
        }
        return null;
    }

    private static void processPartitionedBy(PartitionedBy<Object> node, AnalyzedTableElements<Object> tableElements, RelationName relationName, @Nullable ColumnIdent routing) {
        for (Object partitionByColumn : node.columns()) {
            assert (partitionByColumn instanceof String);
            ColumnIdent partitionedByIdent = ColumnIdent.fromPath((String)partitionByColumn);
            AnalyzedTableElements.changeToPartitionedByColumn(tableElements, partitionedByIdent, false, relationName);
            if (routing == null || !routing.equals(partitionedByIdent)) continue;
            throw new IllegalArgumentException(CLUSTERED_BY_IN_PARTITIONED_ERROR);
        }
    }

    private static boolean hasColumnDefinition(AnalyzedTableElements tableElements, ColumnIdent columnIdent) {
        return tableElements.columnIdents().contains(columnIdent) || columnIdent.name().equalsIgnoreCase("_id");
    }
}

