/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateSnapshot;
import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SnapshotSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.CreateSnapshotException;
import io.crate.exceptions.PartitionUnknownException;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Table;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.TransportCreateSnapshotAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;

public class CreateSnapshotPlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(CreateSnapshotPlan.class);
    private final AnalyzedCreateSnapshot createSnapshot;

    public CreateSnapshotPlan(AnalyzedCreateSnapshot createSnapshot) {
        this.createSnapshot = createSnapshot;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        CreateSnapshotRequest request = CreateSnapshotPlan.createRequest(this.createSnapshot, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults, dependencies.schemas());
        TransportCreateSnapshotAction transportCreateSnapshotAction = dependencies.transportActionProvider().transportCreateSnapshotAction();
        transportCreateSnapshotAction.execute(request, new OneRowActionListener<CreateSnapshotResponse>(consumer, response -> {
            SnapshotInfo snapshotInfo = response.getSnapshotInfo();
            if (snapshotInfo != null && snapshotInfo.state() == SnapshotState.FAILED) {
                String reason = response.getSnapshotInfo().reason().replaceAll("Index", "Table").replaceAll("Indices", "Tables");
                consumer.accept(null, new CreateSnapshotException(this.createSnapshot.snapshot(), reason));
                return new Row1(-1L);
            }
            return new Row1(1L);
        }));
    }

    @VisibleForTesting
    public static CreateSnapshotRequest createRequest(AnalyzedCreateSnapshot createSnapshot, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, Schemas schemas) {
        HashSet<Object> snapshotIndices;
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        Settings settings = GenericPropertiesConverter.genericPropertiesToSettings(createSnapshot.properties().map(eval), SnapshotSettings.SETTINGS);
        boolean ignoreUnavailable = SnapshotSettings.IGNORE_UNAVAILABLE.get(settings);
        if (createSnapshot.tables().isEmpty()) {
            for (SchemaInfo schemaInfo : schemas) {
                for (TableInfo tableInfo : schemaInfo.getTables()) {
                    if (!(tableInfo instanceof DocTableInfo)) continue;
                    Operation.blockedRaiseException(tableInfo, Operation.READ);
                }
            }
            snapshotIndices = new HashSet<String>(AnalyzedCreateSnapshot.ALL_INDICES);
        } else {
            snapshotIndices = new HashSet(createSnapshot.tables().size());
            for (Table<Symbol> table : createSnapshot.tables()) {
                DocTableInfo docTableInfo;
                try {
                    docTableInfo = (DocTableInfo)schemas.resolveTableInfo(table.getName(), Operation.CREATE_SNAPSHOT, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
                }
                catch (ResourceUnknownException e) {
                    if (ignoreUnavailable) {
                        LOGGER.info("Ignore unknown relation '{}' for the '{}' snapshot'", (Object)table.getName(), (Object)createSnapshot.snapshot());
                        continue;
                    }
                    throw e;
                }
                if (table.partitionProperties().isEmpty()) {
                    snapshotIndices.addAll(Arrays.asList(docTableInfo.concreteIndices()));
                    continue;
                }
                PartitionName partitionName = PartitionPropertiesAnalyzer.toPartitionName(docTableInfo, Lists2.map(table.partitionProperties(), x -> x.map(eval)));
                if (!docTableInfo.partitions().contains(partitionName)) {
                    if (!ignoreUnavailable) {
                        throw new PartitionUnknownException(partitionName);
                    }
                    LOGGER.info("ignoring unknown partition of table '{}' with ident '{}'", (Object)partitionName.relationName(), (Object)partitionName.ident());
                    continue;
                }
                snapshotIndices.add(partitionName.asIndexName());
            }
        }
        return new CreateSnapshotRequest(createSnapshot.snapshot().getRepository(), createSnapshot.snapshot().getSnapshotId().getName()).includeGlobalState(true).waitForCompletion(SnapshotSettings.WAIT_FOR_COMPLETION.get(settings)).indices(snapshotIndices.toArray(new String[0])).indicesOptions(IndicesOptions.fromOptions(ignoreUnavailable, true, true, false, IndicesOptions.lenientExpandOpen())).settings(settings);
    }
}

