/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateRepository;
import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.repositories.RepositoryParamValidator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.common.settings.Settings;

public class CreateRepositoryPlan
implements Plan {
    private final AnalyzedCreateRepository createRepository;

    public CreateRepositoryPlan(AnalyzedCreateRepository createRepository) {
        this.createRepository = createRepository;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        PutRepositoryRequest request = CreateRepositoryPlan.createRequest(this.createRepository, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults, dependencies.repositoryParamValidator());
        dependencies.repositoryService().execute(request).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }

    @VisibleForTesting
    public static PutRepositoryRequest createRequest(AnalyzedCreateRepository createRepository, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, RepositoryParamValidator repositoryParamValidator) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        GenericProperties<Object> genericProperties = createRepository.properties().map(eval);
        Settings settings = GenericPropertiesConverter.genericPropertiesToSettings(genericProperties, repositoryParamValidator.settingsForType(createRepository.type()).all());
        repositoryParamValidator.validate(createRepository.type(), createRepository.properties(), settings);
        PutRepositoryRequest request = new PutRepositoryRequest(createRepository.name());
        request.type(createRepository.type());
        request.settings(settings);
        return request;
    }
}

