/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateBlobTable;
import io.crate.analyze.NumberOfShards;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableParameter;
import io.crate.analyze.TableParameters;
import io.crate.analyze.TablePropertiesAnalyzer;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.GenericProperties;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;

public class CreateBlobTablePlan
implements Plan {
    private final AnalyzedCreateBlobTable analyzedBlobTable;
    private final NumberOfShards numberOfShards;

    public CreateBlobTablePlan(AnalyzedCreateBlobTable analyzedBlobTable, NumberOfShards numberOfShards) {
        this.analyzedBlobTable = analyzedBlobTable;
        this.numberOfShards = numberOfShards;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        RelationName relationName = this.analyzedBlobTable.relationName();
        Settings settings = CreateBlobTablePlan.buildSettings(this.analyzedBlobTable.createBlobTable(), plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults, this.numberOfShards);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(BlobIndex.fullIndexName(relationName.name()), settings);
        OneRowActionListener<CreateIndexResponse> listener = new OneRowActionListener<CreateIndexResponse>(consumer, r -> new Row1(1L));
        dependencies.createIndexAction().execute(createIndexRequest, listener);
    }

    @VisibleForTesting
    public static Settings buildSettings(CreateBlobTable<Symbol> createBlobTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults, NumberOfShards numberOfShards) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, params, subQueryResults);
        CreateBlobTable<Object> blobTable = createBlobTable.map(eval);
        GenericProperties<Object> properties = blobTable.genericProperties();
        TableParameter tableParameter = new TableParameter();
        TablePropertiesAnalyzer.analyzeWithBoundValues(tableParameter, TableParameters.CREATE_BLOB_TABLE_PARAMETERS, properties, true);
        Settings.Builder builder = Settings.builder();
        builder.put(tableParameter.settings());
        builder.put(BlobIndicesService.SETTING_INDEX_BLOBS_ENABLED.getKey(), true);
        ClusteredBy<Object> clusteredBy = blobTable.clusteredBy();
        int numShards = clusteredBy != null ? numberOfShards.fromClusteredByClause(clusteredBy) : numberOfShards.defaultNumberOfShards();
        builder.put("index.number_of_shards", numShards);
        return builder.build();
    }
}

