/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterTable;
import io.crate.analyze.BoundAlterTable;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableParameter;
import io.crate.analyze.TableParameters;
import io.crate.analyze.TablePropertiesAnalyzer;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.Table;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Settings;

public class AlterTablePlan
implements Plan {
    private final AnalyzedAlterTable alterTable;

    public AlterTablePlan(AnalyzedAlterTable alterTable) {
        this.alterTable = alterTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        BoundAlterTable stmt = AlterTablePlan.bind(this.alterTable, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults);
        dependencies.alterTableOperation().executeAlterTable(stmt).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }

    public static BoundAlterTable bind(AnalyzedAlterTable analyzedAlterTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, params, subQueryResults);
        DocTableInfo docTableInfo = analyzedAlterTable.tableInfo();
        AlterTable<Object> alterTable = analyzedAlterTable.alterTable().map(eval);
        Table<Object> table = alterTable.table();
        PartitionName partitionName = PartitionPropertiesAnalyzer.createPartitionName(table.partitionProperties(), docTableInfo);
        TableParameters tableParameters = AlterTablePlan.getTableParameterInfo(table, partitionName);
        TableParameter tableParameter = AlterTablePlan.getTableParameter(alterTable, tableParameters);
        AlterTablePlan.maybeRaiseBlockedException(docTableInfo, tableParameter.settings());
        return new BoundAlterTable(docTableInfo, partitionName, tableParameter, table.excludePartitions(), docTableInfo.isPartitioned());
    }

    private static TableParameters getTableParameterInfo(Table table, @Nullable PartitionName partitionName) {
        if (partitionName == null) {
            return TableParameters.TABLE_ALTER_PARAMETER_INFO;
        }
        assert (!table.excludePartitions()) : "Alter table ONLY not supported when using a partition";
        return TableParameters.PARTITION_PARAMETER_INFO;
    }

    public static TableParameter getTableParameter(AlterTable<Object> node, TableParameters tableParameters) {
        TableParameter tableParameter = new TableParameter();
        if (!node.genericProperties().isEmpty()) {
            TablePropertiesAnalyzer.analyzeWithBoundValues(tableParameter, tableParameters, node.genericProperties(), false);
        } else if (!node.resetProperties().isEmpty()) {
            TablePropertiesAnalyzer.analyzeResetProperties(tableParameter, tableParameters, node.resetProperties());
        }
        return tableParameter;
    }

    static void maybeRaiseBlockedException(TableInfo tableInfo, Settings tableSettings) {
        if (tableSettings.size() != 1 || tableSettings.get("index.blocks.metadata") == null && tableSettings.get("index.blocks.read_only") == null) {
            Operation.blockedRaiseException(tableInfo, Operation.ALTER);
        }
    }
}

