/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterTableOpenClose;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Table;
import java.util.function.Function;

public class AlterTableOpenClosePlan
implements Plan {
    private final AnalyzedAlterTableOpenClose analyzedAlterTable;

    public AlterTableOpenClosePlan(AnalyzedAlterTableOpenClose analyzedAlterTable) {
        this.analyzedAlterTable = analyzedAlterTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        DocTableInfo tableInfo = this.analyzedAlterTable.tableInfo();
        Table<Object> table = this.analyzedAlterTable.table().map(eval);
        PartitionName partitionName = null;
        if (tableInfo.isPartitioned()) {
            partitionName = PartitionPropertiesAnalyzer.createPartitionName(table.partitionProperties(), tableInfo);
        }
        dependencies.alterTableOperation().executeAlterTableOpenClose(tableInfo, this.analyzedAlterTable.isOpenTable(), partitionName).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }
}

