/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterTableDropCheckConstraint;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.BoundAddColumn;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.ddl.AlterTableAddColumnPlan;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.CheckConstraint;
import org.elasticsearch.common.settings.Settings;

public class AlterTableDropCheckConstraintPlan
implements Plan {
    private final AnalyzedAlterTableDropCheckConstraint dropCheckConstraint;

    public AlterTableDropCheckConstraintPlan(AnalyzedAlterTableDropCheckConstraint dropCheckConstraint) {
        this.dropCheckConstraint = dropCheckConstraint;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        dependencies.alterTableOperation().executeAlterTableAddColumn(AlterTableDropCheckConstraintPlan.bind(this.dropCheckConstraint)).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }

    @VisibleForTesting
    public static BoundAddColumn bind(AnalyzedAlterTableDropCheckConstraint dropCheckConstraint) {
        DocTableInfo tableInfo = dropCheckConstraint.tableInfo();
        AnalyzedTableElements<Object> tableElementsBound = new AnalyzedTableElements<Object>();
        AlterTableAddColumnPlan.addExistingPrimaryKeys(tableInfo, tableElementsBound);
        tableInfo.checkConstraints().stream().filter(c -> !dropCheckConstraint.name().equals(c.name())).forEach(c -> tableElementsBound.addCheckConstraint(tableInfo.ident(), (CheckConstraint<?>)c));
        return new BoundAddColumn(tableInfo, tableElementsBound, Settings.builder().build(), AnalyzedTableElements.finalizeAndValidate(tableInfo.ident(), new AnalyzedTableElements<Symbol>(), tableElementsBound), false, false);
    }
}

