/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterTableAddColumn;
import io.crate.analyze.AnalyzedColumnDefinition;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.analyze.BoundAddColumn;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.CheckConstraint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.settings.Settings;

public class AlterTableAddColumnPlan
implements Plan {
    private final AnalyzedAlterTableAddColumn alterTable;

    public AlterTableAddColumnPlan(AnalyzedAlterTableAddColumn alterTable) {
        this.alterTable = alterTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        BoundAddColumn stmt = AlterTableAddColumnPlan.bind(this.alterTable, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults, dependencies.fulltextAnalyzerResolver());
        dependencies.alterTableOperation().executeAlterTableAddColumn(stmt).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }

    @VisibleForTesting
    public static BoundAddColumn bind(AnalyzedAlterTableAddColumn alterTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults, FulltextAnalyzerResolver fulltextAnalyzerResolver) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, params, subQueryResults);
        DocTableInfo tableInfo = alterTable.tableInfo();
        AnalyzedTableElements<Object> tableElements = alterTable.analyzedTableElements().map(eval);
        for (AnalyzedColumnDefinition<Object> column : tableElements.columns()) {
            AlterTableAddColumnPlan.ensureColumnLeafsAreNew(column, tableInfo);
        }
        AlterTableAddColumnPlan.addExistingPrimaryKeys(tableInfo, tableElements);
        AlterTableAddColumnPlan.ensureNoIndexDefinitions(tableElements.columns());
        AlterTableAddColumnPlan.addExistingCheckConstraints(tableInfo, tableElements);
        AnalyzedTableElements<Symbol> tableElementsUnboundWithExpressions = alterTable.analyzedTableElementsWithExpressions();
        Map<String, Object> mapping = AnalyzedTableElements.finalizeAndValidate(tableInfo.ident(), tableElementsUnboundWithExpressions, tableElements);
        int numCurrentPks = tableInfo.primaryKey().size();
        if (tableInfo.primaryKey().contains(DocSysColumns.ID)) {
            --numCurrentPks;
        }
        Settings tableSettings = AnalyzedTableElements.validateAndBuildSettings(tableElements, fulltextAnalyzerResolver);
        boolean hasNewPrimaryKeys = AnalyzedTableElements.primaryKeys(tableElements).size() > numCurrentPks;
        boolean hasGeneratedColumns = tableElementsUnboundWithExpressions.hasGeneratedColumns();
        return new BoundAddColumn(tableInfo, tableElements, tableSettings, mapping, hasNewPrimaryKeys, hasGeneratedColumns);
    }

    private static void ensureColumnLeafsAreNew(AnalyzedColumnDefinition<Object> column, TableInfo tableInfo) {
        if (!(column.isParentColumn() && column.hasChildren() || tableInfo.getReference(column.ident()) == null)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The table %s already has a column named %s", tableInfo.ident().sqlFqn(), column.ident().sqlFqn()));
        }
        for (AnalyzedColumnDefinition<Object> child : column.children()) {
            AlterTableAddColumnPlan.ensureColumnLeafsAreNew(child, tableInfo);
        }
    }

    static void addExistingPrimaryKeys(DocTableInfo tableInfo, AnalyzedTableElements<Object> tableElements) {
        LinkedHashSet<ColumnIdent> pkIncludingAncestors = new LinkedHashSet<ColumnIdent>();
        for (ColumnIdent pkIdent : tableInfo.primaryKey()) {
            if (pkIdent.name().equals("_id")) continue;
            ColumnIdent maybeParent = pkIdent;
            pkIncludingAncestors.add(maybeParent);
            while ((maybeParent = maybeParent.getParent()) != null) {
                pkIncludingAncestors.add(maybeParent);
            }
        }
        ArrayList<ColumnIdent> columnsToBuildHierarchy = new ArrayList<ColumnIdent>(pkIncludingAncestors);
        columnsToBuildHierarchy.sort(Comparator.comparingInt(c -> c.path().size()));
        HashMap columns = new HashMap();
        for (ColumnIdent column : columnsToBuildHierarchy) {
            Reference reference;
            ColumnIdent parent = column.getParent();
            AnalyzedColumnDefinition parentDef = (AnalyzedColumnDefinition)columns.get(parent);
            AnalyzedColumnDefinition columnDef = new AnalyzedColumnDefinition(null, parentDef);
            columns.put(column, columnDef);
            columnDef.ident(column);
            if (tableInfo.primaryKey().contains(column)) {
                columnDef.setPrimaryKeyConstraint();
            }
            if ((reference = Objects.requireNonNull(tableInfo.getReference(column), "Must be able to retrieve Reference for any column that is part of `primaryKey()`")).valueType().id() != 12) {
                columnDef.indexConstraint(reference.indexType());
            }
            columnDef.dataType(reference.valueType().getName());
            if (parentDef != null) {
                parentDef.addChild(columnDef);
            }
            if (!column.isTopLevel()) continue;
            tableElements.add(columnDef);
        }
        for (ColumnIdent columnIdent : tableInfo.partitionedBy()) {
            AnalyzedTableElements.changeToPartitionedByColumn(tableElements, columnIdent, true, tableInfo.ident());
        }
    }

    private static void ensureNoIndexDefinitions(List<AnalyzedColumnDefinition<Object>> columns) {
        for (AnalyzedColumnDefinition<Object> column : columns) {
            if (column.isIndexColumn()) {
                throw new UnsupportedOperationException("Adding an index using ALTER TABLE ADD COLUMN is not supported");
            }
            AlterTableAddColumnPlan.ensureNoIndexDefinitions(column.children());
        }
    }

    private static void addExistingCheckConstraints(DocTableInfo tableInfo, AnalyzedTableElements<Object> tableElements) {
        List<CheckConstraint<Symbol>> checkConstraints = tableInfo.checkConstraints();
        for (int i = 0; i < checkConstraints.size(); ++i) {
            tableElements.addCheckConstraint(tableInfo.ident(), checkConstraints.get(i));
        }
    }
}

