/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterBlobTable;
import io.crate.analyze.BoundAlterTable;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableParameter;
import io.crate.analyze.TableParameters;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.ddl.AlterTablePlan;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.AlterTable;
import java.util.function.Function;

public class AlterBlobTablePlan
implements Plan {
    private final AnalyzedAlterBlobTable analyzedAlterTable;

    public AlterBlobTablePlan(AnalyzedAlterBlobTable analyzedAlterTable) {
        this.analyzedAlterTable = analyzedAlterTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        TableInfo tableInfo = this.analyzedAlterTable.tableInfo();
        AlterTable<Object> alterTable = this.analyzedAlterTable.alterTable().map(eval);
        TableParameter tableParameter = AlterTablePlan.getTableParameter(alterTable, TableParameters.ALTER_BLOB_TABLE_PARAMETERS);
        AlterTablePlan.maybeRaiseBlockedException(tableInfo, tableParameter.settings());
        BoundAlterTable stmt = new BoundAlterTable(tableInfo, null, tableParameter, true, false);
        dependencies.alterTableOperation().executeAlterTable(stmt).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1(rCount == null ? -1L : rCount)));
    }
}

