/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node;

import io.crate.Streamer;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.dsl.phases.HashJoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.NestedLoopPhase;
import io.crate.execution.dsl.phases.PKLookupPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.phases.TableFunctionCollectPhase;
import io.crate.types.DataTypes;
import java.util.Locale;

public class StreamerVisitor {
    private static final ExecutionPhaseStreamerVisitor EXECUTION_PHASE_STREAMER_VISITOR = new ExecutionPhaseStreamerVisitor();

    private StreamerVisitor() {
    }

    public static Streamer<?>[] streamersFromOutputs(ExecutionPhase executionPhase) {
        return executionPhase.accept(EXECUTION_PHASE_STREAMER_VISITOR, null);
    }

    private static class ExecutionPhaseStreamerVisitor
    extends ExecutionPhaseVisitor<Void, Streamer<?>[]> {
        private static final Streamer<?>[] COUNT_STREAMERS = new Streamer[]{DataTypes.LONG};

        private ExecutionPhaseStreamerVisitor() {
        }

        @Override
        public Streamer<?>[] visitMergePhase(MergePhase phase, Void context) {
            return DataTypes.getStreamers(phase.outputTypes());
        }

        @Override
        public Streamer<?>[] visitRoutedCollectPhase(RoutedCollectPhase phase, Void context) {
            return DataTypes.getStreamers(phase.outputTypes());
        }

        @Override
        public Streamer<?>[] visitPKLookup(PKLookupPhase pkLookupPhase, Void context) {
            return DataTypes.getStreamers(pkLookupPhase.outputTypes());
        }

        @Override
        public Streamer<?>[] visitCountPhase(CountPhase phase, Void context) {
            return COUNT_STREAMERS;
        }

        @Override
        public Streamer<?>[] visitNestedLoopPhase(NestedLoopPhase phase, Void context) {
            return DataTypes.getStreamers(phase.outputTypes());
        }

        @Override
        public Streamer<?>[] visitHashJoinPhase(HashJoinPhase phase, Void context) {
            return DataTypes.getStreamers(phase.outputTypes());
        }

        @Override
        public Streamer<?>[] visitFileUriCollectPhase(FileUriCollectPhase phase, Void context) {
            return DataTypes.getStreamers(phase.outputTypes());
        }

        @Override
        public Streamer<?>[] visitTableFunctionCollect(TableFunctionCollectPhase phase, Void context) {
            return DataTypes.getStreamers(phase.outputTypes());
        }

        @Override
        protected Streamer<?>[] visitExecutionPhase(ExecutionPhase node, Void context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Got unsupported ExecutionNode %s", node.getClass().getName()));
        }
    }
}

