/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.distribution;

import io.crate.planner.distribution.DistributionType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class DistributionInfo
implements Writeable {
    public static final DistributionInfo DEFAULT_BROADCAST = new DistributionInfo(DistributionType.BROADCAST);
    public static final DistributionInfo DEFAULT_SAME_NODE = new DistributionInfo(DistributionType.SAME_NODE);
    public static final DistributionInfo DEFAULT_MODULO = new DistributionInfo(DistributionType.MODULO);
    private DistributionType distributionType;
    private int distributeByColumn;

    public DistributionInfo(DistributionType distributionType, int distributeByColumn) {
        this.distributionType = distributionType;
        this.distributeByColumn = distributeByColumn;
    }

    public DistributionInfo(StreamInput in) throws IOException {
        this.distributionType = DistributionType.values()[in.readVInt()];
        this.distributeByColumn = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.distributionType.ordinal());
        out.writeVInt(this.distributeByColumn);
    }

    public DistributionInfo(DistributionType distributionType) {
        this(distributionType, 0);
    }

    public DistributionType distributionType() {
        return this.distributionType;
    }

    public int distributeByColumn() {
        return this.distributeByColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionInfo that = (DistributionInfo)o;
        return this.distributeByColumn == that.distributeByColumn && this.distributionType == that.distributionType;
    }

    public int hashCode() {
        int result = this.distributionType.hashCode();
        result = 31 * result + this.distributeByColumn;
        return result;
    }

    public String toString() {
        return "DistributionInfo{distributionType=" + this.distributionType + ", distributeByColumn=" + this.distributeByColumn + "}";
    }
}

