/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.consumer;

import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Reference;
import java.util.Collection;

public class OrderByWithAggregationValidator {
    private static final String INVALID_FIELD_TEMPLATE = "ORDER BY expression '%s' must appear in the select clause when grouping or global aggregation is used";
    private static final String INVALID_FIELD_IN_DISTINCT_TEMPLATE = "ORDER BY expression '%s' must appear in the select clause when SELECT DISTINCT is used";
    private static final InnerValidator INNER_VALIDATOR = new InnerValidator();

    public static void validate(Symbol symbol, Collection<? extends Symbol> outputSymbols, boolean isDistinct) throws UnsupportedOperationException {
        symbol.accept(INNER_VALIDATOR, new ValidatorContext(outputSymbols, isDistinct));
    }

    private static class InnerValidator
    extends SymbolVisitor<ValidatorContext, Void> {
        private InnerValidator() {
        }

        @Override
        public Void visitFunction(Function symbol, ValidatorContext context) {
            for (Symbol symbol2 : context.outputSymbols) {
                if (symbol2.equals(symbol)) {
                    return null;
                }
                if (!(symbol2 instanceof AliasSymbol) || !((AliasSymbol)symbol2).symbol().equals(symbol)) continue;
                return null;
            }
            if (context.isDistinct) {
                throw new UnsupportedOperationException(Symbols.format(OrderByWithAggregationValidator.INVALID_FIELD_IN_DISTINCT_TEMPLATE, symbol));
            }
            if (symbol.type() == FunctionType.SCALAR) {
                for (Symbol symbol3 : symbol.arguments()) {
                    symbol3.accept(this, context);
                }
            } else {
                throw new UnsupportedOperationException(Symbols.format("ORDER BY function '%s' is not allowed. Only scalar functions can be used", symbol));
            }
            return null;
        }

        @Override
        public Void visitReference(Reference ref, ValidatorContext context) {
            return InnerValidator.ensureOutputsContainColumn(ref, context);
        }

        @Override
        public Void visitField(ScopedSymbol field, ValidatorContext context) {
            return InnerValidator.ensureOutputsContainColumn(field, context);
        }

        private static Void ensureOutputsContainColumn(Symbol symbol, ValidatorContext context) {
            if (context.outputSymbols.contains(symbol)) {
                return null;
            }
            for (Symbol symbol2 : context.outputSymbols) {
                if (!(symbol2 instanceof AliasSymbol) || !((AliasSymbol)symbol2).symbol().equals(symbol)) continue;
                return null;
            }
            String template = context.isDistinct ? OrderByWithAggregationValidator.INVALID_FIELD_IN_DISTINCT_TEMPLATE : OrderByWithAggregationValidator.INVALID_FIELD_TEMPLATE;
            throw new UnsupportedOperationException(Symbols.format(template, symbol));
        }

        @Override
        public Void visitSymbol(Symbol symbol, ValidatorContext context) {
            return null;
        }
    }

    private static class ValidatorContext {
        private final Collection<? extends Symbol> outputSymbols;
        private final boolean isDistinct;

        ValidatorContext(Collection<? extends Symbol> outputSymbols, boolean isDistinct) {
            this.outputSymbols = outputSymbols;
            this.isDistinct = isDistinct;
        }
    }
}

