/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.consumer;

import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.operators.Insert;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.PlanHint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;

public final class InsertFromSubQueryPlanner {
    public static final String RETURNING_VERSION_ERROR_MSG = "Returning clause for Insert is only supported when all nodes in the cluster running at least version 4.2.0";

    private InsertFromSubQueryPlanner() {
    }

    public static LogicalPlan plan(AnalyzedInsertStatement statement, PlannerContext plannerContext, LogicalPlanner logicalPlanner, SubqueryPlanner subqueryPlanner) {
        if (statement.outputs() != null && !plannerContext.clusterState().getNodes().getMinNodeVersion().onOrAfter(Version.V_4_2_0)) {
            throw new UnsupportedFeatureException(RETURNING_VERSION_ERROR_MSG);
        }
        ArrayList<Reference> targetColsExclPartitionCols = new ArrayList<Reference>(statement.columns().size() - statement.tableInfo().partitionedBy().size());
        for (Reference column : statement.columns()) {
            if (statement.tableInfo().partitionedBy().contains(column.column())) continue;
            targetColsExclPartitionCols.add(column);
        }
        List<Symbol> columnSymbols = InputColumns.create(targetColsExclPartitionCols, new InputColumns.SourceSymbols(statement.columns()));
        List<Symbol> outputs = statement.outputs() == null ? List.of(new InputColumn(0, DataTypes.LONG)) : statement.outputs();
        ColumnIndexWriterProjection indexWriterProjection = new ColumnIndexWriterProjection(statement.tableInfo().ident(), null, statement.tableInfo().primaryKey(), statement.columns(), targetColsExclPartitionCols, columnSymbols, statement.isIgnoreDuplicateKeys(), statement.onDuplicateKeyAssignments(), statement.primaryKeySymbols(), statement.partitionedBySymbols(), statement.tableInfo().clusteredBy(), statement.clusteredBySymbol(), Settings.EMPTY, statement.tableInfo().isPartitioned(), outputs, statement.outputs() == null ? List.of() : statement.outputs());
        LogicalPlan plannedSubQuery = logicalPlanner.plan(statement.subQueryRelation(), plannerContext, subqueryPlanner, EnumSet.of(PlanHint.PREFER_SOURCE_LOOKUP, PlanHint.AVOID_TOP_LEVEL_FETCH));
        EvalProjection castOutputs = InsertFromSubQueryPlanner.createCastProjection(statement.columns(), plannedSubQuery.outputs());
        return new Insert(plannedSubQuery, indexWriterProjection, castOutputs);
    }

    @Nullable
    private static EvalProjection createCastProjection(List<Reference> targetCols, List<Symbol> sourceCols) {
        ArrayList<Symbol> casts = new ArrayList<Symbol>(targetCols.size());
        boolean requiresCasts = false;
        for (int i = 0; i < sourceCols.size(); ++i) {
            Symbol output = sourceCols.get(i);
            Reference targetCol = targetCols.get(i);
            InputColumn inputColumn = new InputColumn(i, output.valueType());
            DataType<?> targetType = targetCol.valueType();
            if (targetType.id() == DataTypes.UNDEFINED.id() || targetType.equals(output.valueType())) {
                casts.add(inputColumn);
                continue;
            }
            requiresCasts = true;
            casts.add(inputColumn.cast(targetType, new CastMode[0]));
        }
        return requiresCasts ? new EvalProjection(casts) : null;
    }
}

