/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.GeneratedColumnExpander;
import io.crate.analyze.WhereClause;
import io.crate.analyze.where.DocKeys;
import io.crate.analyze.where.EqualityExtractor;
import io.crate.analyze.where.WhereClauseAnalyzer;
import io.crate.analyze.where.WhereClauseValidator;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class WhereClauseOptimizer {
    private WhereClauseOptimizer() {
    }

    public static DetailedQuery optimize(EvaluatingNormalizer normalizer, Symbol query, DocTableInfo table, TransactionContext txnCtx, NodeContext nodeCtx) {
        List<List<Symbol>> clusteredByValues;
        DocKeys docKeys;
        Symbol queryGenColsProcessed = GeneratedColumnExpander.maybeExpand(query, table.generatedColumns(), Lists2.concat(table.partitionedByColumns(), Lists2.map(table.primaryKey(), table::getReference)), nodeCtx);
        if (!query.equals(queryGenColsProcessed)) {
            query = normalizer.normalize(queryGenColsProcessed, txnCtx);
        }
        WhereClause.validateVersioningColumnsUsage(query);
        boolean versionInQuery = Symbols.containsColumn(query, DocSysColumns.VERSION);
        boolean sequenceVersioningInQuery = Symbols.containsColumn(query, DocSysColumns.SEQ_NO) && Symbols.containsColumn(query, DocSysColumns.PRIMARY_TERM);
        List<ColumnIdent> pkCols = WhereClauseOptimizer.pkColsInclVersioning(table, versionInQuery, sequenceVersioningInQuery);
        EqualityExtractor eqExtractor = new EqualityExtractor(normalizer);
        List<List<Symbol>> pkValues = eqExtractor.extractExactMatches(pkCols, query, txnCtx);
        int clusterIdxWithinPK = table.primaryKey().indexOf(table.clusteredBy());
        if (pkValues == null) {
            docKeys = null;
        } else {
            List<Integer> partitionIndicesWithinPks = null;
            if (table.isPartitioned()) {
                partitionIndicesWithinPks = WhereClauseOptimizer.getPartitionIndices(table.primaryKey(), table.partitionedBy());
            }
            docKeys = new DocKeys(pkValues, versionInQuery, sequenceVersioningInQuery, clusterIdxWithinPK, partitionIndicesWithinPks);
        }
        List<List<Symbol>> partitionValues = null;
        if (table.isPartitioned()) {
            partitionValues = eqExtractor.extractExactMatches(table.partitionedBy(), query, txnCtx);
        }
        Set<Symbol> clusteredBy = Collections.emptySet();
        if (table.clusteredBy() != null && (clusteredByValues = eqExtractor.extractParentMatches(Collections.singletonList(table.clusteredBy()), query, txnCtx)) != null) {
            clusteredBy = new HashSet<Symbol>(clusteredByValues.size());
            for (List<Symbol> s : clusteredByValues) {
                clusteredBy.add(s.get(0));
            }
        }
        WhereClauseValidator.validate(query);
        return new DetailedQuery(query, docKeys, partitionValues, clusteredBy);
    }

    public static List<Integer> getPartitionIndices(List<ColumnIdent> pkCols, List<ColumnIdent> partitionCols) {
        ArrayList<Integer> result = new ArrayList<Integer>(partitionCols.size());
        for (int i = 0; i < partitionCols.size(); ++i) {
            ColumnIdent partitionCol = partitionCols.get(i);
            int partColIdxInPks = pkCols.indexOf(partitionCol);
            if (partColIdxInPks < 0) continue;
            result.add(partColIdxInPks);
        }
        return result;
    }

    private static List<ColumnIdent> pkColsInclVersioning(DocTableInfo table, boolean versionInQuery, boolean seqNoAndPrimaryTermInQuery) {
        if (versionInQuery) {
            ArrayList<ColumnIdent> pkCols = new ArrayList<ColumnIdent>(table.primaryKey().size() + 1);
            pkCols.addAll(table.primaryKey());
            pkCols.add(DocSysColumns.VERSION);
            return pkCols;
        }
        if (seqNoAndPrimaryTermInQuery) {
            ArrayList<ColumnIdent> pkCols = new ArrayList<ColumnIdent>(table.primaryKey().size() + 1);
            pkCols.addAll(table.primaryKey());
            pkCols.add(DocSysColumns.SEQ_NO);
            pkCols.add(DocSysColumns.PRIMARY_TERM);
            return pkCols;
        }
        return table.primaryKey();
    }

    public static class DetailedQuery {
        private final Symbol query;
        private final DocKeys docKeys;
        private final List<List<Symbol>> partitions;
        private final Set<Symbol> clusteredByValues;

        DetailedQuery(Symbol query, DocKeys docKeys, List<List<Symbol>> partitionValues, Set<Symbol> clusteredByValues) {
            this.query = query;
            this.docKeys = docKeys;
            this.partitions = Objects.requireNonNullElse(partitionValues, Collections.emptyList());
            this.clusteredByValues = clusteredByValues;
        }

        public Optional<DocKeys> docKeys() {
            return Optional.ofNullable(this.docKeys);
        }

        public List<List<Symbol>> partitions() {
            return this.partitions;
        }

        public Symbol query() {
            return this.query;
        }

        public Set<Symbol> clusteredBy() {
            return this.clusteredByValues;
        }

        public WhereClause toBoundWhereClause(DocTableInfo table, Row params, SubQueryResults subQueryResults, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx) {
            if (this.docKeys != null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " must not be converted to a WhereClause if docKeys are present");
            }
            SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
            Symbol boundQuery = binder.apply(this.query);
            HashSet<Symbol> clusteredBy = new HashSet<Symbol>(this.clusteredByValues.size());
            for (Symbol clusteredByValue : this.clusteredByValues) {
                clusteredBy.add(binder.apply(clusteredByValue));
            }
            if (table.isPartitioned()) {
                if (table.partitions().isEmpty()) {
                    return WhereClause.NO_MATCH;
                }
                WhereClauseAnalyzer.PartitionResult partitionResult = WhereClauseAnalyzer.resolvePartitions(boundQuery, table, txnCtx, nodeCtx);
                return new WhereClause(partitionResult.query, partitionResult.partitions, clusteredBy);
            }
            return new WhereClause(boundQuery, Collections.emptyList(), clusteredBy);
        }
    }
}

