/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class UnionExecutionPlan
implements ExecutionPlan,
ResultDescription {
    private final ExecutionPlan left;
    private final ExecutionPlan right;
    private final MergePhase mergePhase;
    private int unfinishedLimit;
    private int unfinishedOffset;
    private int numOutputs;
    private final int maxRowsPerNode;
    @Nullable
    private PositionalOrderBy orderBy;

    public UnionExecutionPlan(ExecutionPlan left, ExecutionPlan right, MergePhase mergePhase, int unfinishedLimit, int unfinishedOffset, int numOutputs, int maxRowsPerNode, @Nullable PositionalOrderBy orderBy) {
        this.left = left;
        this.right = right;
        if (mergePhase.numInputs() != 2) {
            throw new IllegalArgumentException("Number of inputs of MergePhase needs to be two.");
        }
        this.mergePhase = mergePhase;
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.numOutputs = numOutputs;
        this.maxRowsPerNode = maxRowsPerNode;
        this.orderBy = orderBy;
    }

    public MergePhase mergePhase() {
        return this.mergePhase;
    }

    public ExecutionPlan left() {
        return this.left;
    }

    public ExecutionPlan right() {
        return this.right;
    }

    @Override
    public <C, R> R accept(ExecutionPlanVisitor<C, R> visitor, C context) {
        return visitor.visitUnionPlan(this, context);
    }

    @Override
    public void addProjection(Projection projection) {
        this.mergePhase.addProjection(projection);
        this.numOutputs = projection.outputs().size();
    }

    @Override
    public void addProjection(Projection projection, int unfinishedLimit, int unfinishedOffset, @Nullable PositionalOrderBy unfinishedOrderBy) {
        this.addProjection(projection);
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.orderBy = unfinishedOrderBy;
    }

    @Override
    public ResultDescription resultDescription() {
        return this;
    }

    @Override
    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.mergePhase.distributionInfo(distributionInfo);
    }

    @Override
    public Collection<String> nodeIds() {
        return this.mergePhase.nodeIds();
    }

    @Override
    @Nullable
    public PositionalOrderBy orderBy() {
        return this.orderBy;
    }

    @Override
    public int limit() {
        return this.unfinishedLimit;
    }

    @Override
    public int maxRowsPerNode() {
        return this.maxRowsPerNode;
    }

    @Override
    public int offset() {
        return this.unfinishedOffset;
    }

    @Override
    public int numOutputs() {
        return this.numOutputs;
    }

    @Override
    public List<DataType<?>> streamOutputs() {
        return this.mergePhase.outputTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionExecutionPlan that = (UnionExecutionPlan)o;
        return this.unfinishedLimit == that.unfinishedLimit && this.unfinishedOffset == that.unfinishedOffset && this.numOutputs == that.numOutputs && this.maxRowsPerNode == that.maxRowsPerNode && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.mergePhase, that.mergePhase) && Objects.equals(this.orderBy, that.orderBy);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right, this.mergePhase, this.unfinishedLimit, this.unfinishedOffset, this.numOutputs, this.maxRowsPerNode, this.orderBy);
    }
}

