/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedStatement;
import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.LogicalPlan;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class SubqueryPlanner {
    private final Function<SelectSymbol, LogicalPlan> planSubSelects;

    public SubqueryPlanner(Function<SelectSymbol, LogicalPlan> planSubSelects) {
        this.planSubSelects = planSubSelects;
    }

    public Map<LogicalPlan, SelectSymbol> planSubQueries(AnalyzedStatement statement) {
        Visitor visitor = new Visitor();
        statement.visitSymbols(visitor);
        return visitor.subQueries;
    }

    private void planSubquery(SelectSymbol selectSymbol, Map<LogicalPlan, SelectSymbol> subQueries) {
        LogicalPlan subPlan = this.planSubSelects.apply(selectSymbol);
        subQueries.put(subPlan, selectSymbol);
    }

    private class Visitor
    extends DefaultTraversalSymbolVisitor<Symbol, Void>
    implements Consumer<Symbol> {
        private final Map<LogicalPlan, SelectSymbol> subQueries = new HashMap<LogicalPlan, SelectSymbol>();

        private Visitor() {
        }

        @Override
        public Void visitSelectSymbol(SelectSymbol selectSymbol, Symbol parent) {
            SubqueryPlanner.this.planSubquery(selectSymbol, this.subQueries);
            return null;
        }

        @Override
        public void accept(Symbol symbol) {
            symbol.accept(this, null);
        }
    }
}

