/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.crate.action.sql.SessionContext;
import io.crate.analyze.WhereClause;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.ReaderAllocations;
import io.crate.planner.fetch.IndexBaseBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;

final class RoutingBuilder {
    final Map<RelationName, List<Routing>> routingListByTable = new HashMap<RelationName, List<Routing>>();
    private final ClusterState clusterState;
    private final RoutingProvider routingProvider;

    RoutingBuilder(ClusterState clusterState, RoutingProvider routingProvider) {
        this.clusterState = clusterState;
        this.routingProvider = routingProvider;
    }

    Routing allocateRouting(TableInfo tableInfo, WhereClause where, RoutingProvider.ShardSelection shardSelection, SessionContext sessionContext) {
        Routing routing = tableInfo.getRouting(this.clusterState, this.routingProvider, where, shardSelection, sessionContext);
        List<Routing> existingRoutings = this.routingListByTable.get(tableInfo.ident());
        if (existingRoutings == null) {
            existingRoutings = new ArrayList<Routing>();
            this.routingListByTable.put(tableInfo.ident(), existingRoutings);
        }
        existingRoutings.add(routing);
        return routing;
    }

    ReaderAllocations buildReaderAllocations() {
        HashMultimap indicesByTable = HashMultimap.create();
        IndexBaseBuilder indexBaseBuilder = new IndexBaseBuilder();
        HashMap<String, Map<Integer, String>> shardNodes = new HashMap<String, Map<Integer, String>>();
        for (Map.Entry<RelationName, List<Routing>> tableRoutingEntry : this.routingListByTable.entrySet()) {
            RelationName table = tableRoutingEntry.getKey();
            List<Routing> routingList = tableRoutingEntry.getValue();
            for (Routing routing : routingList) {
                RoutingBuilder.allocateRoutingNodes(shardNodes, routing.locations());
                for (Map.Entry<String, Map<String, IntIndexedContainer>> entry : routing.locations().entrySet()) {
                    Map<String, IntIndexedContainer> shardsByIndex = entry.getValue();
                    indicesByTable.putAll((Object)table, shardsByIndex.keySet());
                    for (Map.Entry<String, IntIndexedContainer> shardsByIndexEntry : shardsByIndex.entrySet()) {
                        indexBaseBuilder.allocate(shardsByIndexEntry.getKey(), shardsByIndexEntry.getValue());
                    }
                }
            }
        }
        this.routingListByTable.clear();
        return new ReaderAllocations(indexBaseBuilder.build(), shardNodes, (Multimap<RelationName, String>)indicesByTable);
    }

    private static void allocateRoutingNodes(Map<String, Map<Integer, String>> shardNodes, Map<String, Map<String, IntIndexedContainer>> locations) {
        for (Map.Entry<String, Map<String, IntIndexedContainer>> indicesByNodeId : locations.entrySet()) {
            String nodeId = indicesByNodeId.getKey();
            for (Map.Entry<String, IntIndexedContainer> shardsByIndexEntry : indicesByNodeId.getValue().entrySet()) {
                String index = shardsByIndexEntry.getKey();
                IntIndexedContainer shards = shardsByIndexEntry.getValue();
                Map<Integer, String> shardsOnIndex = shardNodes.get(index);
                if (shardsOnIndex == null) {
                    shardsOnIndex = new HashMap<Integer, String>(shards.size());
                    shardNodes.put(index, shardsOnIndex);
                    for (IntCursor id : shards) {
                        shardsOnIndex.put(id.value, nodeId);
                    }
                    continue;
                }
                for (IntCursor id : shards) {
                    String allocatedNodeId = shardsOnIndex.get(id.value);
                    assert (allocatedNodeId == null || allocatedNodeId.equals(nodeId)) : "allocatedNodeId must match nodeId";
                    shardsOnIndex.put(id.value, nodeId);
                }
            }
        }
    }

    public ShardRouting resolveShard(String indexName, String id, String routing) {
        return this.routingProvider.forId(this.clusterState, indexName, id, routing);
    }
}

