/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.google.common.collect.Multimap;
import io.crate.metadata.RelationName;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class ReaderAllocations {
    private final TreeMap<Integer, String> readerIndices = new TreeMap();
    private final Map<String, IntSet> nodeReaders = new HashMap<String, IntSet>();
    private final TreeMap<String, Integer> bases;
    private final Multimap<RelationName, String> tableIndices;
    private final Map<String, RelationName> indicesToIdents;

    ReaderAllocations(TreeMap<String, Integer> bases, Map<String, Map<Integer, String>> shardNodes, Multimap<RelationName, String> tableIndices) {
        this.bases = bases;
        this.tableIndices = tableIndices;
        this.indicesToIdents = new HashMap<String, RelationName>(tableIndices.values().size());
        for (Map.Entry entry : tableIndices.entries()) {
            this.indicesToIdents.put((String)entry.getValue(), (RelationName)entry.getKey());
        }
        for (Map.Entry entry : bases.entrySet()) {
            this.readerIndices.put((Integer)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry entry : shardNodes.entrySet()) {
            Integer base = bases.get(entry.getKey());
            if (base == null) continue;
            for (Map.Entry nodeEntries : ((Map)entry.getValue()).entrySet()) {
                int readerId = base + (Integer)nodeEntries.getKey();
                IntSet readerIds = this.nodeReaders.get(nodeEntries.getValue());
                if (readerIds == null) {
                    readerIds = new IntHashSet();
                    this.nodeReaders.put((String)nodeEntries.getValue(), readerIds);
                }
                readerIds.add(readerId);
            }
        }
    }

    public Multimap<RelationName, String> tableIndices() {
        return this.tableIndices;
    }

    public TreeMap<Integer, String> indices() {
        return this.readerIndices;
    }

    public Map<String, IntSet> nodeReaders() {
        return this.nodeReaders;
    }

    public TreeMap<String, Integer> bases() {
        return this.bases;
    }

    public Map<String, RelationName> indicesToIdents() {
        return this.indicesToIdents;
    }
}

