/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.OrderBy;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.consumer.OrderByPositionVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PositionalOrderBy {
    private final int[] indices;
    private final boolean[] reverseFlags;
    private final boolean[] nullsFirst;

    public PositionalOrderBy(int[] indices, boolean[] reverseFlags, boolean[] nullsFirst) {
        assert (indices.length == reverseFlags.length && reverseFlags.length == nullsFirst.length) : "all parameters to OrderByPositions must have the same length";
        assert (indices.length > 0) : "parameters must have length > 0";
        this.indices = indices;
        this.reverseFlags = reverseFlags;
        this.nullsFirst = nullsFirst;
    }

    public int[] indices() {
        return this.indices;
    }

    public boolean[] reverseFlags() {
        return this.reverseFlags;
    }

    public boolean[] nullsFirst() {
        return this.nullsFirst;
    }

    public String toString() {
        return "OrderByPositions{indices=" + Arrays.toString(this.indices) + ", reverseFlags=" + Arrays.toString(this.reverseFlags) + ", nullsFirst=" + Arrays.toString(this.nullsFirst) + "}";
    }

    @Nullable
    public PositionalOrderBy tryMapToNewOutputs(List<Symbol> oldOutputs, List<Symbol> newOutputs) {
        int[] newIndices = new int[this.indices.length];
        for (int i = 0; i < this.indices.length; ++i) {
            int idxInOldOutputs = this.indices[i];
            Symbol orderByExpr = oldOutputs.get(idxInOldOutputs);
            int idxInNewOutputs = newOutputs.indexOf(orderByExpr);
            if (idxInNewOutputs < 0) {
                return null;
            }
            newIndices[i] = idxInNewOutputs;
        }
        return new PositionalOrderBy(newIndices, Arrays.copyOf(this.reverseFlags, this.reverseFlags.length), Arrays.copyOf(this.nullsFirst, this.nullsFirst.length));
    }

    @Nullable
    public static PositionalOrderBy fromStream(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            return null;
        }
        int[] indices = new int[size];
        boolean[] reverseFlags = new boolean[size];
        boolean[] nullsFirst = new boolean[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = in.readVInt();
            reverseFlags[i] = in.readBoolean();
            nullsFirst[i] = in.readBoolean();
        }
        return new PositionalOrderBy(indices, reverseFlags, nullsFirst);
    }

    public static void toStream(@Nullable PositionalOrderBy orderBy, StreamOutput out) throws IOException {
        if (orderBy == null) {
            out.writeVInt(0);
            return;
        }
        out.writeVInt(orderBy.indices.length);
        for (int i = 0; i < orderBy.indices.length; ++i) {
            out.writeVInt(orderBy.indices[i]);
            out.writeBoolean(orderBy.reverseFlags[i]);
            out.writeBoolean(orderBy.nullsFirst[i]);
        }
    }

    @Nullable
    public static PositionalOrderBy of(@Nullable OrderBy orderBy, List<? extends Symbol> orderByInputSymbols) {
        if (orderBy == null) {
            return null;
        }
        int[] indices = OrderByPositionVisitor.orderByPositions(orderBy.orderBySymbols(), orderByInputSymbols);
        if (indices.length == 0) {
            return null;
        }
        return new PositionalOrderBy(indices, orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionalOrderBy that = (PositionalOrderBy)o;
        return Arrays.equals(this.indices, that.indices) && Arrays.equals(this.reverseFlags, that.reverseFlags) && Arrays.equals(this.nullsFirst, that.nullsFirst);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.reverseFlags);
        result = 31 * result + Arrays.hashCode(this.nullsFirst);
        return result;
    }
}

