/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.WhereClause;
import io.crate.data.Row;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.ReaderAllocations;
import io.crate.planner.RoutingBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;

public class PlannerContext {
    private final UUID jobId;
    private final CoordinatorTxnCtx coordinatorTxnCtx;
    private final int fetchSize;
    private final RoutingBuilder routingBuilder;
    private final RoutingProvider routingProvider;
    private final NodeContext nodeCtx;
    private final ClusterState clusterState;
    private int executionPhaseId = 0;
    private final String handlerNode;
    @Nullable
    private final Row params;

    public static PlannerContext forSubPlan(PlannerContext context) {
        return PlannerContext.forSubPlan(context, context.fetchSize);
    }

    public static PlannerContext forSubPlan(PlannerContext context, int fetchSize) {
        return new PlannerContext(context.clusterState, context.routingProvider, UUID.randomUUID(), context.coordinatorTxnCtx, context.nodeCtx, fetchSize, context.params);
    }

    public PlannerContext(ClusterState clusterState, RoutingProvider routingProvider, UUID jobId, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, int fetchSize, @Nullable Row params) {
        this.routingProvider = routingProvider;
        this.nodeCtx = nodeCtx;
        this.params = params;
        this.routingBuilder = new RoutingBuilder(clusterState, routingProvider);
        this.clusterState = clusterState;
        this.jobId = jobId;
        this.coordinatorTxnCtx = coordinatorTxnCtx;
        this.fetchSize = fetchSize;
        this.handlerNode = clusterState.getNodes().getLocalNodeId();
    }

    @Nullable
    public Row params() {
        return this.params;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public CoordinatorTxnCtx transactionContext() {
        return this.coordinatorTxnCtx;
    }

    public String handlerNode() {
        return this.handlerNode;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public int nextExecutionPhaseId() {
        return this.executionPhaseId++;
    }

    public Routing allocateRouting(TableInfo tableInfo, WhereClause where, RoutingProvider.ShardSelection shardSelection, SessionContext sessionContext) {
        return this.routingBuilder.allocateRouting(tableInfo, where, shardSelection, sessionContext);
    }

    public ShardRouting resolveShard(String indexName, String id, @Nullable String routing) {
        return this.routingBuilder.resolveShard(indexName, id, routing);
    }

    public ReaderAllocations buildReaderAllocations() {
        return this.routingBuilder.buildReaderAllocations();
    }

    public NodeContext nodeContext() {
        return this.nodeCtx;
    }

    public ClusterState clusterState() {
        return this.clusterState;
    }
}

