/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.MultiPhaseExecutor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import java.util.Map;

public class MultiPhasePlan
implements Plan {
    @VisibleForTesting
    protected final Plan rootPlan;
    @VisibleForTesting
    protected final Map<LogicalPlan, SelectSymbol> dependencies;

    public static Plan createIfNeeded(Plan rootPlan, Map<LogicalPlan, SelectSymbol> dependencies) {
        if (dependencies.isEmpty()) {
            return rootPlan;
        }
        return new MultiPhasePlan(rootPlan, dependencies);
    }

    private MultiPhasePlan(Plan rootPlan, Map<LogicalPlan, SelectSymbol> dependencies) {
        this.rootPlan = rootPlan;
        this.dependencies = dependencies;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.SELECT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencyCarrier, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        MultiPhaseExecutor.execute(this.dependencies, dependencyCarrier, plannerContext, params).whenComplete((subQueryValues, failure) -> {
            if (failure == null) {
                this.rootPlan.execute(dependencyCarrier, plannerContext, consumer, params, (SubQueryResults)subQueryValues);
            } else {
                consumer.accept(null, (Throwable)failure);
            }
        });
    }
}

