/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.data.Paging;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.Collect;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class Merge
implements ExecutionPlan,
ResultDescription {
    private final ExecutionPlan subExecutionPlan;
    private final MergePhase mergePhase;
    private int unfinishedLimit;
    private int unfinishedOffset;
    private int numOutputs;
    private final int maxRowsPerNode;
    @Nullable
    private PositionalOrderBy orderBy;

    public static ExecutionPlan ensureOnHandler(ExecutionPlan subExecutionPlan, PlannerContext plannerContext, List<Projection> projections) {
        ResultDescription resultDescription = subExecutionPlan.resultDescription();
        assert (resultDescription != null) : "all plans must have a result description. Plan without: " + subExecutionPlan;
        Projection topN = ProjectionBuilder.topNOrEvalIfNeeded(resultDescription.limit(), resultDescription.offset(), resultDescription.numOutputs(), resultDescription.streamOutputs());
        if (ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), resultDescription.nodeIds())) {
            return Merge.addProjections(subExecutionPlan, projections, resultDescription, topN);
        }
        Merge.maybeUpdatePageSizeHint(subExecutionPlan, resultDescription.maxRowsPerNode());
        List<String> handlerNodeIds = Collections.singletonList(plannerContext.handlerNode());
        MergePhase mergePhase = new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), "mergeOnHandler", resultDescription.nodeIds().size(), 1, handlerNodeIds, resultDescription.streamOutputs(), Merge.addProjection(projections, topN), DistributionInfo.DEFAULT_BROADCAST, resultDescription.orderBy());
        return new Merge(subExecutionPlan, mergePhase, -1, 0, resultDescription.numOutputs(), resultDescription.limit(), resultDescription.orderBy());
    }

    private static void maybeUpdatePageSizeHint(ExecutionPlan subExecutionPlan, int maxRowsPerNode) {
        if (Paging.shouldPage(maxRowsPerNode)) {
            Merge.updateNodePageSizeHint(subExecutionPlan, maxRowsPerNode);
        }
    }

    private static void updateNodePageSizeHint(ExecutionPlan subExecutionPlan, int nodePageSize) {
        if (!(subExecutionPlan instanceof Collect) || nodePageSize == -1) {
            return;
        }
        CollectPhase collectPhase = ((Collect)subExecutionPlan).collectPhase();
        if (collectPhase instanceof RoutedCollectPhase) {
            ((RoutedCollectPhase)collectPhase).pageSizeHint(nodePageSize);
        }
    }

    private static ExecutionPlan addProjections(ExecutionPlan subExecutionPlan, List<Projection> projections, ResultDescription resultDescription, Projection topN) {
        for (Projection projection : projections) {
            assert (projection.outputs().size() == resultDescription.numOutputs()) : "projection must not affect numOutputs";
            subExecutionPlan.addProjection(projection);
        }
        if (topN != null) {
            subExecutionPlan.addProjection(topN, -1, 0, resultDescription.orderBy());
        }
        return subExecutionPlan;
    }

    private static List<Projection> addProjection(List<Projection> projections, @Nullable Projection projection) {
        if (projection == null) {
            return projections;
        }
        if (projections.isEmpty()) {
            return Collections.singletonList(projection);
        }
        projections.add(projection);
        return projections;
    }

    public static ExecutionPlan ensureOnHandler(ExecutionPlan subExecutionPlan, PlannerContext plannerContext) {
        return Merge.ensureOnHandler(subExecutionPlan, plannerContext, Collections.emptyList());
    }

    public Merge(ExecutionPlan subExecutionPlan, MergePhase mergePhase, int unfinishedLimit, int unfinishedOffset, int numOutputs, int maxRowsPerNode, @Nullable PositionalOrderBy orderBy) {
        this.subExecutionPlan = subExecutionPlan;
        this.mergePhase = mergePhase;
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.numOutputs = numOutputs;
        this.maxRowsPerNode = maxRowsPerNode;
        this.orderBy = orderBy;
    }

    @Override
    public <C, R> R accept(ExecutionPlanVisitor<C, R> visitor, C context) {
        return visitor.visitMerge(this, context);
    }

    @Override
    public void addProjection(Projection projection) {
        this.mergePhase.addProjection(projection);
        this.numOutputs = projection.outputs().size();
    }

    @Override
    public void addProjection(Projection projection, int unfinishedLimit, int unfinishedOffset, @Nullable PositionalOrderBy unfinishedOrderBy) {
        this.addProjection(projection);
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.orderBy = unfinishedOrderBy;
    }

    @Override
    public ResultDescription resultDescription() {
        return this;
    }

    @Override
    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.mergePhase.distributionInfo(distributionInfo);
    }

    public MergePhase mergePhase() {
        return this.mergePhase;
    }

    public ExecutionPlan subPlan() {
        return this.subExecutionPlan;
    }

    @Override
    public Collection<String> nodeIds() {
        return this.mergePhase.nodeIds();
    }

    @Override
    @Nullable
    public PositionalOrderBy orderBy() {
        return this.orderBy;
    }

    @Override
    public int limit() {
        return this.unfinishedLimit;
    }

    @Override
    public int maxRowsPerNode() {
        return this.maxRowsPerNode;
    }

    @Override
    public int offset() {
        return this.unfinishedOffset;
    }

    @Override
    public int numOutputs() {
        return this.numOutputs;
    }

    @Override
    public List<DataType<?>> streamOutputs() {
        return this.mergePhase.outputTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Merge merge = (Merge)o;
        return this.unfinishedLimit == merge.unfinishedLimit && this.unfinishedOffset == merge.unfinishedOffset && this.numOutputs == merge.numOutputs && this.maxRowsPerNode == merge.maxRowsPerNode && Objects.equals(this.subExecutionPlan, merge.subExecutionPlan) && Objects.equals(this.mergePhase, merge.mergePhase) && Objects.equals(this.orderBy, merge.orderBy);
    }

    public int hashCode() {
        return Objects.hash(this.subExecutionPlan, this.mergePhase, this.unfinishedLimit, this.unfinishedOffset, this.numOutputs, this.maxRowsPerNode, this.orderBy);
    }
}

