/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedDropView;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.RelationsUnknown;
import io.crate.execution.ddl.views.DropViewRequest;
import io.crate.execution.ddl.views.DropViewResponse;
import io.crate.execution.support.OneRowActionListener;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.function.Function;

public class DropViewPlan
implements Plan {
    private final AnalyzedDropView dropView;

    DropViewPlan(AnalyzedDropView dropView) {
        this.dropView = dropView;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        DropViewRequest request = new DropViewRequest(this.dropView.views(), this.dropView.ifExists());
        Function<DropViewResponse, Row> responseToRow = resp -> {
            if (this.dropView.ifExists() || resp.missing().isEmpty()) {
                return new Row1((long)this.dropView.views().size() - (long)resp.missing().size());
            }
            throw new RelationsUnknown(resp.missing());
        };
        dependencies.dropViewAction().execute(request, new OneRowActionListener<DropViewResponse>(consumer, responseToRow));
    }
}

