/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.collect.files;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import io.crate.analyze.CopyFromParserProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class CSVLineParser {
    private final ArrayList<String> keyList = new ArrayList();
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ObjectReader csvReader;

    public CSVLineParser(CopyFromParserProperties properties) {
        CsvMapper mapper = new CsvMapper().enable(CsvParser.Feature.TRIM_SPACES);
        if (properties.emptyStringAsNull()) {
            mapper.enable(CsvParser.Feature.EMPTY_STRING_AS_NULL);
        }
        CsvSchema csvSchema = mapper.typedSchemaFor(String.class).withColumnSeparator(properties.columnSeparator());
        this.csvReader = mapper.readerWithTypedSchemaFor(String.class).with((FormatSchema)csvSchema);
    }

    public void parseHeader(String header) throws IOException {
        MappingIterator iterator = this.csvReader.readValues(header.getBytes(StandardCharsets.UTF_8));
        iterator.readAll(this.keyList);
        HashSet<String> keySet = new HashSet<String>(this.keyList);
        keySet.remove("");
        if (keySet.size() != this.keyList.size() || keySet.size() == 0) {
            throw new IllegalArgumentException("Invalid header: duplicate entries or no entries present");
        }
    }

    public byte[] parse(String row) throws IOException {
        MappingIterator iterator = this.csvReader.readValues(row.getBytes(StandardCharsets.UTF_8));
        this.out.reset();
        XContentBuilder jsonBuilder = new XContentBuilder(JsonXContent.JSON_XCONTENT, this.out).startObject();
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= this.keyList.size()) {
                throw new IllegalArgumentException("Number of values exceeds number of keys");
            }
            jsonBuilder.field(this.keyList.get(i), iterator.next());
            ++i;
        }
        jsonBuilder.endObject().close();
        return this.out.toByteArray();
    }
}

