/*
 * Decompiled with CFR 0.152.
 */
package io.crate.netty;

import io.crate.common.collections.BorrowedItem;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.transport.netty4.Netty4Transport;

@Singleton
public class EventLoopGroups {
    public static final String WORKER_THREAD_PREFIX = "netty-worker";
    private static final Logger LOGGER = LogManager.getLogger(EventLoopGroups.class);
    private int refs = 0;
    private EventLoopGroup worker;

    public synchronized BorrowedItem<EventLoopGroup> getEventLoopGroup(Settings settings) {
        if (this.worker == null) {
            ThreadFactory workerThreads = EsExecutors.daemonThreadFactory(settings, WORKER_THREAD_PREFIX);
            int workerCount = Netty4Transport.WORKER_COUNT.get(settings);
            this.worker = Epoll.isAvailable() ? new EpollEventLoopGroup(workerCount, workerThreads) : new NioEventLoopGroup(workerCount, workerThreads);
        }
        ++this.refs;
        return new BorrowedItem<EventLoopGroup>(this.worker, () -> {
            EventLoopGroups eventLoopGroups = this;
            synchronized (eventLoopGroups) {
                --this.refs;
                if (this.refs == 0) {
                    Future shutdownGracefully = this.worker.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
                    shutdownGracefully.awaitUninterruptibly();
                    if (!shutdownGracefully.isSuccess()) {
                        LOGGER.warn("Error closing netty event loop group", shutdownGracefully.cause());
                    }
                    this.worker = null;
                }
            }
        });
    }
}

