/*
 * Decompiled with CFR 0.152.
 */
package io.crate.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportSettings;

public final class CrateChannelBootstrapFactory {
    private CrateChannelBootstrapFactory() {
    }

    public static ServerBootstrap newChannelBootstrap(Settings settings, EventLoopGroup eventLoopGroup) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        if (Epoll.isAvailable()) {
            serverBootstrap.channel(EpollServerSocketChannel.class);
        } else {
            serverBootstrap.channel(NioServerSocketChannel.class);
        }
        Boolean reuseAddress = TransportSettings.TCP_REUSE_ADDRESS.get(settings);
        return ((ServerBootstrap)serverBootstrap.group(eventLoopGroup).option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress)).childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress).childOption(ChannelOption.TCP_NODELAY, (Object)TransportSettings.TCP_NO_DELAY.get(settings)).childOption(ChannelOption.SO_KEEPALIVE, (Object)TransportSettings.TCP_KEEP_ALIVE.get(settings));
    }
}

