/*
 * Decompiled with CFR 0.152.
 */
package io.crate.monitor;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.monitor.os.OsStats;

public class ExtendedOsStats
implements Writeable {
    private final Cpu cpu;
    private final OsStats osStats;
    private final long timestamp;
    private final long uptime;
    private final double[] loadAverage;

    public ExtendedOsStats(long timestamp, Cpu cpu, double[] load, long uptime, OsStats osStats) {
        this.timestamp = timestamp;
        this.cpu = cpu;
        this.loadAverage = load;
        this.uptime = uptime;
        this.osStats = osStats;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public TimeValue uptime() {
        return new TimeValue(this.uptime, TimeUnit.MILLISECONDS);
    }

    public double[] loadAverage() {
        return this.loadAverage;
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public OsStats osStats() {
        return this.osStats;
    }

    public ExtendedOsStats(StreamInput in) throws IOException {
        this.timestamp = in.readLong();
        this.uptime = in.readLong();
        this.loadAverage = in.readDoubleArray();
        this.cpu = in.readOptionalWriteable(Cpu::new);
        this.osStats = in.readOptionalWriteable(OsStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.uptime);
        out.writeDoubleArray(this.loadAverage);
        out.writeOptionalWriteable(this.cpu);
        out.writeOptionalWriteable(this.osStats);
    }

    public static class Cpu
    implements Writeable {
        private final short percent;

        Cpu(short percent) {
            this.percent = percent;
        }

        public short percent() {
            return this.percent;
        }

        public Cpu(StreamInput in) throws IOException {
            if (in.getVersion().onOrAfter(Version.V_4_1_0)) {
                this.percent = in.readShort();
            } else {
                in.readShort();
                in.readShort();
                in.readShort();
                in.readShort();
                this.percent = in.readShort();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
                out.writeShort(this.percent);
            } else {
                out.writeShort((short)-1);
                out.writeShort((short)-1);
                out.writeShort((short)-1);
                out.writeShort((short)-1);
                out.writeShort(this.percent);
            }
        }
    }
}

