/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.view;

import io.crate.metadata.RelationName;
import io.crate.metadata.view.ViewMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ViewsMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "views";
    private final Map<String, ViewMetadata> viewByName;

    ViewsMetadata(Map<String, ViewMetadata> viewByName) {
        this.viewByName = viewByName;
    }

    public ViewsMetadata(StreamInput in) throws IOException {
        int numViews = in.readVInt();
        this.viewByName = new HashMap<String, ViewMetadata>(numViews);
        for (int i = 0; i < numViews; ++i) {
            this.viewByName.put(in.readString(), new ViewMetadata(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.viewByName.size());
        for (Map.Entry<String, ViewMetadata> view : this.viewByName.entrySet()) {
            out.writeString(view.getKey());
            view.getValue().writeTo(out);
        }
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        for (Map.Entry<String, ViewMetadata> entry : this.viewByName.entrySet()) {
            ViewMetadata view = entry.getValue();
            builder.startObject(entry.getKey());
            builder.field("stmt", view.stmt());
            builder.field("owner", view.owner());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static ViewsMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, ViewMetadata> views = new HashMap<String, ViewMetadata>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME && parser.currentName().equals(TYPE)) {
            if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                    String viewName = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
                    String stmt = null;
                    String owner = null;
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if ("stmt".equals(parser.currentName())) {
                            parser.nextToken();
                            stmt = parser.text();
                        }
                        if (!"owner".equals(parser.currentName())) continue;
                        parser.nextToken();
                        owner = parser.textOrNull();
                    }
                    if (stmt == null) {
                        throw new ElasticsearchParseException("failed to parse views, expected field 'stmt' in object", new Object[0]);
                    }
                    views.put(viewName, new ViewMetadata(stmt, owner));
                }
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ElasticsearchParseException("failed to parse views, expected an object token at the end", new Object[0]);
            }
        }
        return new ViewsMetadata(views);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewsMetadata that = (ViewsMetadata)o;
        return this.viewByName.equals(that.viewByName);
    }

    public int hashCode() {
        return Objects.hash(this.viewByName);
    }

    public boolean contains(RelationName relationName) {
        return this.viewByName.containsKey(relationName.fqn());
    }

    public Iterable<String> names() {
        return this.viewByName.keySet();
    }

    public static ViewsMetadata addOrReplace(@Nullable ViewsMetadata prevViews, RelationName name, String query, @Nullable String owner) {
        HashMap<String, ViewMetadata> queryByName = prevViews == null ? new HashMap<String, ViewMetadata>() : new HashMap<String, ViewMetadata>(prevViews.viewByName);
        queryByName.put(name.fqn(), new ViewMetadata(query, owner));
        return new ViewsMetadata(queryByName);
    }

    public RemoveResult remove(List<RelationName> names) {
        HashMap<String, ViewMetadata> updatedQueryByName = new HashMap<String, ViewMetadata>(this.viewByName);
        ArrayList<RelationName> missing = new ArrayList<RelationName>(names.size());
        for (RelationName name : names) {
            ViewMetadata removed = updatedQueryByName.remove(name.fqn());
            if (removed != null) continue;
            missing.add(name);
        }
        return new RemoveResult(new ViewsMetadata(updatedQueryByName), missing);
    }

    @Nullable
    public ViewMetadata getView(RelationName name) {
        return this.viewByName.get(name.fqn());
    }

    public class RemoveResult {
        private final ViewsMetadata updatedViews;
        private final List<RelationName> missing;

        RemoveResult(ViewsMetadata updatedViews, List<RelationName> missing) {
            this.updatedViews = updatedViews;
            this.missing = missing;
        }

        public ViewsMetadata updatedViews() {
            return this.updatedViews;
        }

        public List<RelationName> missing() {
            return this.missing;
        }
    }
}

