/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.view;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class ViewMetadata
implements Writeable {
    private final String stmt;
    @Nullable
    private final String owner;

    ViewMetadata(String stmt, @Nullable String owner) {
        this.stmt = stmt;
        this.owner = owner;
    }

    ViewMetadata(StreamInput in) throws IOException {
        this.stmt = in.readString();
        this.owner = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.stmt);
        out.writeOptionalString(this.owner);
    }

    public String stmt() {
        return this.stmt;
    }

    @Nullable
    public String owner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewMetadata view = (ViewMetadata)o;
        return Objects.equals(this.stmt, view.stmt) && Objects.equals(this.owner, view.owner);
    }

    public int hashCode() {
        return Objects.hash(this.stmt, this.owner);
    }
}

