/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.view;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.view.ViewInfo;
import io.crate.metadata.view.ViewInfoFactory;
import io.crate.metadata.view.ViewMetadata;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;

public class InternalViewInfoFactory
implements ViewInfoFactory {
    private Provider<RelationAnalyzer> analyzerProvider;

    @Inject
    public InternalViewInfoFactory(Provider<RelationAnalyzer> analyzerProvider) {
        this.analyzerProvider = analyzerProvider;
    }

    @Override
    public ViewInfo create(RelationName ident, ClusterState state) {
        List<Reference> columns;
        ViewsMetadata meta = (ViewsMetadata)state.metadata().custom("views");
        if (meta == null) {
            return null;
        }
        ViewMetadata view = meta.getView(ident);
        if (view == null) {
            return null;
        }
        try {
            AnalyzedRelation relation = this.analyzerProvider.get().analyze((Query)SqlParser.createStatement(view.stmt()), CoordinatorTxnCtx.systemTransactionContext(), ParamTypeHints.EMPTY);
            ArrayList<Reference> collectedColumns = new ArrayList<Reference>(relation.outputs().size());
            relation.outputs().forEach(field -> collectedColumns.add(new Reference(new ReferenceIdent(ident, Symbols.pathFromSymbol(field).sqlFqn()), RowGranularity.DOC, field.valueType(), null, null)));
            columns = collectedColumns;
        }
        catch (ResourceUnknownException e) {
            columns = Collections.emptyList();
        }
        return new ViewInfo(ident, view.stmt(), columns, view.owner());
    }
}

