/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import io.crate.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.index.mapper.MapperParsingException;

public class MetadataIndexUpgrader
implements UnaryOperator<IndexMetadata> {
    private final Logger logger = LogManager.getLogger(MetadataIndexUpgrader.class);

    @Override
    public IndexMetadata apply(IndexMetadata indexMetadata) {
        return this.createUpdatedIndexMetadata(indexMetadata);
    }

    private IndexMetadata createUpdatedIndexMetadata(IndexMetadata indexMetadata) {
        return IndexMetadata.builder(indexMetadata).putMapping(this.createUpdatedIndexMetadata(indexMetadata.mapping(), indexMetadata.getIndex().getName())).build();
    }

    @VisibleForTesting
    MappingMetadata createUpdatedIndexMetadata(MappingMetadata mappingMetadata, String indexName) {
        Map<String, Object> oldMapping = mappingMetadata.getSourceAsMap();
        LinkedHashMap<String, Object> newMapping = new LinkedHashMap<String, Object>(oldMapping.size());
        block10: for (Map.Entry<String, Object> entry : oldMapping.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            switch (fieldName) {
                case "dynamic_templates": {
                    MetadataIndexUpgrader.handleDynamicTemplates(newMapping, fieldName, (List)fieldNode);
                    continue block10;
                }
                case "_all": {
                    continue block10;
                }
            }
            newMapping.put(fieldName, fieldNode);
        }
        try {
            return new MappingMetadata("default", Map.of("default", newMapping));
        }
        catch (IOException e) {
            this.logger.error("Failed to upgrade mapping for index '" + indexName + "'", (Throwable)e);
            return mappingMetadata;
        }
    }

    private static void handleDynamicTemplates(LinkedHashMap<String, Object> newMapping, String fieldName, List<?> fieldNode) {
        ArrayList templates = new ArrayList();
        for (Object tmplNode : fieldNode) {
            Map tmpl = (Map)tmplNode;
            if (tmpl.size() != 1) {
                throw new MapperParsingException("A dynamic template must be defined with a name");
            }
            Map.Entry tmpEntry = tmpl.entrySet().iterator().next();
            String templateName = (String)tmpEntry.getKey();
            if (templateName.equals("strings")) continue;
            templates.add(tmplNode);
        }
        if (templates.size() > 0) {
            newMapping.put(fieldName, templates);
        }
    }
}

