/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.metadata.DefaultTemplateService;
import io.crate.metadata.IndexParts;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class IndexTemplateUpgrader
implements UnaryOperator<Map<String, IndexTemplateMetadata>> {
    private final Logger logger = LogManager.getLogger(IndexTemplateUpgrader.class);

    @Override
    public Map<String, IndexTemplateMetadata> apply(Map<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> upgradedTemplates = this.archiveUnknownOrInvalidSettings(templates);
        try {
            upgradedTemplates.put("crate_defaults", DefaultTemplateService.createDefaultIndexTemplateMetadata());
        }
        catch (IOException e) {
            this.logger.error("Error while trying to upgrade the default template", (Throwable)e);
        }
        return upgradedTemplates;
    }

    private HashMap<String, IndexTemplateMetadata> archiveUnknownOrInvalidSettings(Map<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> upgradedTemplates = new HashMap<String, IndexTemplateMetadata>(templates.size());
        for (Map.Entry<String, IndexTemplateMetadata> entry : templates.entrySet()) {
            IndexTemplateMetadata templateMetadata = entry.getValue();
            Settings.Builder settingsBuilder = Settings.builder().put(templateMetadata.settings());
            String templateName = entry.getKey();
            if (!IndexParts.isPartitioned(templateName)) {
                upgradedTemplates.put(templateName, templateMetadata);
                continue;
            }
            Settings settings = IndexScopedSettings.DEFAULT_SCOPED_SETTINGS.archiveUnknownOrInvalidSettings(settingsBuilder.build(), e -> {}, (e, ex) -> {}).filter(k -> !k.startsWith("archived."));
            IndexTemplateMetadata.Builder builder = IndexTemplateMetadata.builder(templateName).patterns(templateMetadata.patterns()).order(templateMetadata.order()).settings(settings);
            try {
                for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : templateMetadata.getMappings()) {
                    Map<String, Object> mappingSource = XContentHelper.toMap(((CompressedXContent)objectObjectCursor.value).compressedReference(), XContentType.JSON);
                    Object defaultMapping = mappingSource.get("default");
                    if (defaultMapping instanceof Map && ((Map)defaultMapping).containsKey("_all")) {
                        Map mapping = (Map)defaultMapping;
                        mapping.remove("_all");
                        builder.putMapping((String)objectObjectCursor.key, new CompressedXContent(BytesReference.bytes(XContentFactory.jsonBuilder().value(mappingSource))));
                        continue;
                    }
                    builder.putMapping((String)objectObjectCursor.key, (CompressedXContent)objectObjectCursor.value);
                }
            }
            catch (IOException e2) {
                this.logger.error("Error while trying to upgrade template '" + templateName + "'", (Throwable)e2);
                continue;
            }
            for (ObjectObjectCursor objectObjectCursor : templateMetadata.aliases()) {
                builder.putAlias((AliasMetadata)objectObjectCursor.value);
            }
            upgradedTemplates.put(templateName, builder.build());
        }
        return upgradedTemplates;
    }
}

