/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.table;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.WhereClause;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.ClusterState;

public interface TableInfo
extends RelationInfo {
    public static final Predicate<DataType<?>> IS_OBJECT_ARRAY;

    @Nullable
    public Reference getReference(ColumnIdent var1);

    @Nullable
    default public Reference getReadReference(ColumnIdent columnIdent) {
        Reference ref = this.getReference(columnIdent);
        if (ref == null) {
            return null;
        }
        DataType<?> readType = this.getReadType(columnIdent);
        if (readType.equals(ref.valueType())) {
            return ref;
        }
        return new Reference(ref.ident(), ref.granularity(), readType, ref.columnPolicy(), ref.indexType(), ref.isNullable(), ref.isColumnStoreDisabled(), ref.position(), ref.defaultExpression());
    }

    default public DataType<?> getReadType(ColumnIdent column) {
        Reference ref = this.getReference(column);
        if (ref == null) {
            return DataTypes.UNDEFINED;
        }
        Reference rootRef = ref;
        int arrayDimensions = 0;
        while (!rootRef.column().isTopLevel()) {
            rootRef = this.getReference(rootRef.column().getParent());
            if (!1.$assertionsDisabled && rootRef == null) {
                throw new AssertionError((Object)"The parent column of a nested column must exist");
            }
            if (!IS_OBJECT_ARRAY.test(rootRef.valueType())) continue;
            ++arrayDimensions;
        }
        return ArrayType.makeArray(ref.valueType(), arrayDimensions);
    }

    public Routing getRouting(ClusterState var1, RoutingProvider var2, WhereClause var3, RoutingProvider.ShardSelection var4, SessionContext var5);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        IS_OBJECT_ARRAY = type -> type instanceof ArrayType && ((ArrayType)type).innerType().id() == 12;
    }
}

