/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.table;

import io.crate.common.collections.MapBuilder;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.metadata.table.TableInfo;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;

public enum Operation {
    READ("READ"),
    UPDATE("UPDATE"),
    INSERT("INSERT"),
    DELETE("DELETE"),
    DROP("DROP"),
    ALTER("ALTER"),
    ALTER_BLOCKS("ALTER"),
    ALTER_OPEN_CLOSE("ALTER OPEN/CLOSE"),
    ALTER_TABLE_RENAME("ALTER RENAME"),
    ALTER_REROUTE("ALTER REROUTE"),
    REFRESH("REFRESH"),
    SHOW_CREATE("SHOW CREATE"),
    OPTIMIZE("OPTIMIZE"),
    COPY_TO("COPY TO"),
    RESTORE_SNAPSHOT("RESTORE SNAPSHOT"),
    CREATE_SNAPSHOT("CREATE SNAPSHOT");

    public static final EnumSet<Operation> ALL;
    public static final EnumSet<Operation> SYS_READ_ONLY;
    public static final EnumSet<Operation> READ_ONLY;
    public static final EnumSet<Operation> CLOSED_OPERATIONS;
    public static final EnumSet<Operation> BLOB_OPERATIONS;
    public static final EnumSet<Operation> READ_DISABLED_OPERATIONS;
    public static final EnumSet<Operation> WRITE_DISABLED_OPERATIONS;
    public static final EnumSet<Operation> METADATA_DISABLED_OPERATIONS;
    private final String representation;
    private static final Map<String, EnumSet<Operation>> BLOCK_SETTING_TO_OPERATIONS_MAP;

    private Operation(String representation) {
        this.representation = representation;
    }

    public static EnumSet<Operation> buildFromIndexSettingsAndState(Settings settings, IndexMetadata.State state) {
        if (state == IndexMetadata.State.CLOSE) {
            return CLOSED_OPERATIONS;
        }
        Set<Operation> operations = ALL;
        for (Map.Entry<String, EnumSet<Operation>> entry : BLOCK_SETTING_TO_OPERATIONS_MAP.entrySet()) {
            if (!settings.getAsBoolean(entry.getKey(), false).booleanValue()) continue;
            operations = Sets.intersection((Set)entry.getValue(), operations);
        }
        return EnumSet.copyOf(operations);
    }

    public static void blockedRaiseException(TableInfo tableInfo, Operation operation) {
        if (!tableInfo.supportedOperations().contains((Object)operation)) {
            String exceptionMessage = tableInfo.supportedOperations().equals(CLOSED_OPERATIONS) ? "The relation \"%s\" doesn't support or allow %s operations, as it is currently closed." : (tableInfo.supportedOperations().equals(SYS_READ_ONLY) || tableInfo.supportedOperations().equals(READ_ONLY) ? "The relation \"%s\" doesn't support or allow %s operations, as it is read-only." : "The relation \"%s\" doesn't support or allow %s operations.");
            throw new OperationOnInaccessibleRelationException(tableInfo.ident(), String.format(Locale.ENGLISH, exceptionMessage, new Object[]{tableInfo.ident().fqn(), operation}));
        }
    }

    public String toString() {
        return this.representation;
    }

    static {
        ALL = EnumSet.allOf(Operation.class);
        SYS_READ_ONLY = EnumSet.of(READ);
        READ_ONLY = EnumSet.of(READ, ALTER_BLOCKS);
        CLOSED_OPERATIONS = EnumSet.of(ALTER_OPEN_CLOSE, ALTER_TABLE_RENAME);
        BLOB_OPERATIONS = EnumSet.of(READ, OPTIMIZE, ALTER, ALTER_REROUTE, DROP);
        READ_DISABLED_OPERATIONS = EnumSet.of(UPDATE, new Operation[]{INSERT, DELETE, DROP, ALTER, ALTER_OPEN_CLOSE, ALTER_REROUTE, ALTER_BLOCKS, REFRESH, OPTIMIZE});
        WRITE_DISABLED_OPERATIONS = EnumSet.of(READ, new Operation[]{ALTER, ALTER_OPEN_CLOSE, ALTER_BLOCKS, ALTER_REROUTE, SHOW_CREATE, REFRESH, OPTIMIZE, COPY_TO, CREATE_SNAPSHOT});
        METADATA_DISABLED_OPERATIONS = EnumSet.of(READ, new Operation[]{UPDATE, INSERT, DELETE, ALTER_BLOCKS, ALTER_OPEN_CLOSE, ALTER_REROUTE, REFRESH, SHOW_CREATE, OPTIMIZE});
        BLOCK_SETTING_TO_OPERATIONS_MAP = MapBuilder.newMapBuilder().put("index.blocks.read_only", READ_ONLY).put("index.blocks.read", READ_DISABLED_OPERATIONS).put("index.blocks.write", WRITE_DISABLED_OPERATIONS).put("index.blocks.metadata", METADATA_DISABLED_OPERATIONS).map();
    }
}

