/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.table;

import io.crate.common.Booleans;
import io.crate.sql.tree.ColumnPolicy;

public final class ColumnPolicies {
    public static final String ES_MAPPING_NAME = "dynamic";
    public static final String CRATE_NAME = "column_policy";

    public static ColumnPolicy decodeMappingValue(Object value) {
        if (value == null) {
            return ColumnPolicy.DYNAMIC;
        }
        return ColumnPolicies.decodeMappingValue(String.valueOf(value));
    }

    public static ColumnPolicy decodeMappingValue(String value) {
        if (Booleans.isTrue(value)) {
            return ColumnPolicy.DYNAMIC;
        }
        if (Booleans.isFalse(value)) {
            return ColumnPolicy.IGNORED;
        }
        if (value.equalsIgnoreCase("strict")) {
            return ColumnPolicy.STRICT;
        }
        throw new IllegalArgumentException("Invalid column policy: " + value);
    }

    public static String encodeMappingValue(ColumnPolicy columnPolicy) {
        switch (columnPolicy) {
            case DYNAMIC: {
                return String.valueOf(true);
            }
            case STRICT: {
                return "strict";
            }
            case IGNORED: {
                return String.valueOf(false);
            }
        }
        throw new AssertionError((Object)("Illegal columnPolicy: " + columnPolicy));
    }
}

