/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.analyze.user.Privilege;
import io.crate.execution.engine.collect.files.SummitsContext;
import io.crate.execution.engine.collect.files.SummitsIterable;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.SysChecker;
import io.crate.expression.reference.sys.check.node.SysNodeCheck;
import io.crate.expression.reference.sys.check.node.SysNodeChecks;
import io.crate.expression.reference.sys.job.JobContext;
import io.crate.expression.reference.sys.job.JobContextLog;
import io.crate.expression.reference.sys.operation.OperationContext;
import io.crate.expression.reference.sys.operation.OperationContextLog;
import io.crate.expression.reference.sys.shard.ShardSegment;
import io.crate.expression.reference.sys.shard.ShardSegments;
import io.crate.expression.reference.sys.shard.SysAllocation;
import io.crate.expression.reference.sys.shard.SysAllocations;
import io.crate.expression.reference.sys.snapshot.SysSnapshot;
import io.crate.expression.reference.sys.snapshot.SysSnapshotRestoreInProgress;
import io.crate.expression.reference.sys.snapshot.SysSnapshots;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.sys.MetricsView;
import io.crate.metadata.sys.SysAllocationsTableInfo;
import io.crate.metadata.sys.SysChecksTableInfo;
import io.crate.metadata.sys.SysClusterTableInfo;
import io.crate.metadata.sys.SysHealth;
import io.crate.metadata.sys.SysJobsLogTableInfo;
import io.crate.metadata.sys.SysJobsTableInfo;
import io.crate.metadata.sys.SysMetricsTableInfo;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import io.crate.metadata.sys.SysOperationsLogTableInfo;
import io.crate.metadata.sys.SysOperationsTableInfo;
import io.crate.metadata.sys.SysRepositoriesTableInfo;
import io.crate.metadata.sys.SysSchemaInfo;
import io.crate.metadata.sys.SysSegmentsTableInfo;
import io.crate.metadata.sys.SysSnapshotRestoreTableInfo;
import io.crate.metadata.sys.SysSnapshotsTableInfo;
import io.crate.metadata.sys.SysSummitsTableInfo;
import io.crate.metadata.sys.TableHealth;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;

public class SysTableDefinitions {
    private final Map<RelationName, StaticTableDefinition<?>> tableDefinitions = new HashMap();

    @Inject
    public SysTableDefinitions(JobsLogs jobsLogs, ClusterService clusterService, SysSchemaInfo sysSchemaInfo, Set<SysCheck> sysChecks, SysNodeChecks sysNodeChecks, RepositoriesService repositoriesService, SysSnapshots sysSnapshots, SysAllocations sysAllocations, ShardSegments shardSegmentInfos) {
        Supplier<DiscoveryNode> localNode = clusterService::localNode;
        SystemTable sysClusterTableInfo = (SystemTable)sysSchemaInfo.getTableInfo(SysClusterTableInfo.IDENT.name());
        assert (sysClusterTableInfo != null) : "sys.cluster table must exist in sys schema";
        this.tableDefinitions.put(SysClusterTableInfo.IDENT, new StaticTableDefinition(() -> CompletableFuture.completedFuture(Collections.singletonList(null)), sysClusterTableInfo.expressions(), false));
        SystemTable<JobContext> sysJobsTable = SysJobsTableInfo.create(localNode);
        this.tableDefinitions.put(SysJobsTableInfo.IDENT, new StaticTableDefinition<JobContext>(() -> CompletableFuture.completedFuture(jobsLogs.activeJobs()), sysJobsTable.expressions(), (user, jobCtx) -> user.isSuperUser() || user.name().equals(jobCtx.username()), false));
        SystemTable<JobContextLog> sysJobsLogTable = SysJobsLogTableInfo.create(localNode);
        this.tableDefinitions.put(SysJobsLogTableInfo.IDENT, new StaticTableDefinition<JobContextLog>(() -> CompletableFuture.completedFuture(jobsLogs.jobsLog()), sysJobsLogTable.expressions(), (user, jobCtx) -> user.isSuperUser() || user.name().equals(jobCtx.username()), false));
        this.tableDefinitions.put(SysOperationsTableInfo.IDENT, new StaticTableDefinition<OperationContext>(() -> CompletableFuture.completedFuture(jobsLogs.activeOperations()), SysOperationsTableInfo.create(localNode).expressions(), false));
        this.tableDefinitions.put(SysOperationsLogTableInfo.IDENT, new StaticTableDefinition<OperationContextLog>(() -> CompletableFuture.completedFuture(jobsLogs.operationsLog()), SysOperationsLogTableInfo.create().expressions(), false));
        SysChecker<SysCheck> sysChecker = new SysChecker<SysCheck>(sysChecks);
        this.tableDefinitions.put(SysChecksTableInfo.IDENT, new StaticTableDefinition<SysCheck>(sysChecker::computeResultAndGet, SysChecksTableInfo.create().expressions(), true));
        this.tableDefinitions.put(SysNodeChecksTableInfo.IDENT, new StaticTableDefinition<SysNodeCheck>(() -> CompletableFuture.completedFuture(sysNodeChecks), SysNodeChecksTableInfo.create().expressions(), true));
        this.tableDefinitions.put(SysRepositoriesTableInfo.IDENT, new StaticTableDefinition<Repository>(() -> CompletableFuture.completedFuture(repositoriesService.getRepositoriesList()), SysRepositoriesTableInfo.create(clusterService.getClusterSettings().maskedSettings()).expressions(), false));
        this.tableDefinitions.put(SysSnapshotsTableInfo.IDENT, new StaticTableDefinition<SysSnapshot>(() -> CompletableFuture.completedFuture(sysSnapshots.currentSnapshots()), SysSnapshotsTableInfo.create().expressions(), true));
        this.tableDefinitions.put(SysSnapshotRestoreTableInfo.IDENT, new StaticTableDefinition<SysSnapshotRestoreInProgress>(() -> CompletableFuture.completedFuture(SysSnapshotRestoreTableInfo.snapshotsRestoreInProgress((RestoreInProgress)clusterService.state().custom("restore"))), SysSnapshotRestoreTableInfo.create().expressions(), true));
        this.tableDefinitions.put(SysAllocationsTableInfo.IDENT, new StaticTableDefinition<SysAllocation>(() -> sysAllocations, (user, allocation) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, allocation.fqn()), SysAllocationsTableInfo.create().expressions()));
        SummitsIterable summits = new SummitsIterable();
        this.tableDefinitions.put(SysSummitsTableInfo.IDENT, new StaticTableDefinition<SummitsContext>(() -> CompletableFuture.completedFuture(summits), SysSummitsTableInfo.create().expressions(), false));
        SystemTable<TableHealth> sysHealth = SysHealth.create();
        this.tableDefinitions.put(SysHealth.IDENT, new StaticTableDefinition<TableHealth>(() -> TableHealth.compute(clusterService.state()), sysHealth.expressions(), (user, tableHealth) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, tableHealth.fqn()), true));
        this.tableDefinitions.put(SysMetricsTableInfo.NAME, new StaticTableDefinition<MetricsView>(() -> CompletableFuture.completedFuture(jobsLogs.metrics()), SysMetricsTableInfo.create(localNode).expressions(), false));
        this.tableDefinitions.put(SysSegmentsTableInfo.IDENT, new StaticTableDefinition<ShardSegment>(() -> CompletableFuture.completedFuture(shardSegmentInfos), SysSegmentsTableInfo.create(clusterService::localNode).expressions(), true));
    }

    public StaticTableDefinition<?> get(RelationName relationName) {
        return this.tableDefinitions.get(relationName);
    }

    public <R> void registerTableDefinition(RelationName relationName, StaticTableDefinition<R> definition) {
        StaticTableDefinition<R> existingDefinition = this.tableDefinitions.putIfAbsent(relationName, definition);
        assert (existingDefinition == null) : "A static table definition is already registered for ident=" + relationName.toString();
    }
}

