/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import io.crate.action.sql.SessionContext;
import io.crate.analyze.user.Privilege;
import io.crate.auth.user.User;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.NestableInput;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SystemTable;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import io.crate.metadata.shard.unassigned.UnassignedShard;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.shard.ShardId;

public class SysShardsTableInfo {
    public static final RelationName IDENT = new RelationName("sys", "shards");

    public static Map<ColumnIdent, RowCollectExpressionFactory<UnassignedShard>> unassignedShardsExpressions() {
        return Map.ofEntries(Map.entry(Columns.SCHEMA_NAME, () -> NestableCollectExpression.forFunction(UnassignedShard::schemaName)), Map.entry(Columns.TABLE_NAME, () -> NestableCollectExpression.forFunction(UnassignedShard::tableName)), Map.entry(Columns.PARTITION_IDENT, () -> NestableCollectExpression.forFunction(UnassignedShard::partitionIdent)), Map.entry(Columns.ID, () -> NestableCollectExpression.forFunction(UnassignedShard::id)), Map.entry(Columns.NUM_DOCS, () -> NestableCollectExpression.constant(0L)), Map.entry(Columns.PRIMARY, () -> NestableCollectExpression.forFunction(UnassignedShard::primary)), Map.entry(Columns.RELOCATING_NODE, () -> NestableCollectExpression.constant(null)), Map.entry(Columns.SIZE, () -> NestableCollectExpression.constant(0L)), Map.entry(Columns.STATE, () -> NestableCollectExpression.forFunction(UnassignedShard::state)), Map.entry(Columns.ROUTING_STATE, () -> NestableCollectExpression.forFunction(UnassignedShard::state)), Map.entry(Columns.ORPHAN_PARTITION, () -> NestableCollectExpression.forFunction(UnassignedShard::orphanedPartition)), Map.entry(Columns.RECOVERY, NestedNullObjectExpression::new), Map.entry(Columns.PATH, () -> NestableCollectExpression.constant(null)), Map.entry(Columns.BLOB_PATH, () -> NestableCollectExpression.constant(null)), Map.entry(Columns.MIN_LUCENE_VERSION, () -> NestableCollectExpression.constant(null)), Map.entry(Columns.NODE, NestedNullObjectExpression::new), Map.entry(Columns.SEQ_NO_STATS, NestedNullObjectExpression::new), Map.entry(Columns.TRANSLOG_STATS, NestedNullObjectExpression::new), Map.entry(Columns.RETENTION_LEASES, NestedNullObjectExpression::new));
    }

    public static SystemTable<ShardRowContext> create() {
        return ((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT, RowGranularity.SHARD).add("schema_name", (DataType)DataTypes.STRING, r -> r.indexParts().getSchema())).add("table_name", (DataType)DataTypes.STRING, r -> r.indexParts().getTable())).add("id", (DataType)DataTypes.INTEGER, ShardRowContext::id)).add("partition_ident", (DataType)DataTypes.STRING, ShardRowContext::partitionIdent)).add("num_docs", (DataType)DataTypes.LONG, ShardRowContext::numDocs)).add("primary", (DataType)DataTypes.BOOLEAN, r -> r.indexShard().routingEntry().primary())).add("relocating_node", (DataType)DataTypes.STRING, r -> r.indexShard().routingEntry().relocatingNodeId())).add("size", (DataType)DataTypes.LONG, ShardRowContext::size)).add("state", (DataType)DataTypes.STRING, r -> r.indexShard().state().toString())).add("routing_state", (DataType)DataTypes.STRING, r -> r.indexShard().routingEntry().state().toString())).add("orphan_partition", (DataType)DataTypes.BOOLEAN, ShardRowContext::isOrphanedPartition)).startObject("recovery").add("stage", (DataType)DataTypes.STRING, ShardRowContext::recoveryStage)).add("type", (DataType)DataTypes.STRING, ShardRowContext::recoveryType)).add("total_time", (DataType)DataTypes.LONG, ShardRowContext::recoveryTotalTime)).startObject("size").add("used", (DataType)DataTypes.LONG, ShardRowContext::recoverySizeUsed)).add("reused", (DataType)DataTypes.LONG, ShardRowContext::recoverySizeReused)).add("recovered", (DataType)DataTypes.LONG, ShardRowContext::recoverySizeRecoveredBytes)).add("percent", (DataType)DataTypes.FLOAT, ShardRowContext::recoverySizeRecoveredBytesPercent)).endObject()).startObject("files").add("used", (DataType)DataTypes.INTEGER, ShardRowContext::recoveryFilesUsed)).add("reused", (DataType)DataTypes.INTEGER, ShardRowContext::recoveryFilesReused)).add("recovered", (DataType)DataTypes.INTEGER, ShardRowContext::recoveryFilesRecovered)).add("percent", (DataType)DataTypes.FLOAT, ShardRowContext::recoveryFilesPercent)).endObject()).endObject()).add("path", (DataType)DataTypes.STRING, ShardRowContext::path)).add("blob_path", (DataType)DataTypes.STRING, ShardRowContext::blobPath)).add("min_lucene_version", (DataType)DataTypes.STRING, ShardRowContext::minLuceneVersion)).startObject("node").add("id", (DataType)DataTypes.STRING, x -> x.clusterService().localNode().getId())).add("name", (DataType)DataTypes.STRING, x -> x.clusterService().localNode().getName())).endObject()).startObject(Columns.SEQ_NO_STATS.name()).add("max_seq_no", (DataType)DataTypes.LONG, ShardRowContext::maxSeqNo)).add("local_checkpoint", (DataType)DataTypes.LONG, ShardRowContext::localSeqNoCheckpoint)).add("global_checkpoint", (DataType)DataTypes.LONG, ShardRowContext::globalSeqNoCheckpoint)).endObject()).startObject(Columns.TRANSLOG_STATS.name()).add("size", (DataType)DataTypes.LONG, ShardRowContext::translogSizeInBytes)).add("uncommitted_size", (DataType)DataTypes.LONG, ShardRowContext::translogUncommittedSizeInBytes)).add("number_of_operations", (DataType)DataTypes.INTEGER, ShardRowContext::translogEstimatedNumberOfOperations)).add("uncommitted_operations", (DataType)DataTypes.INTEGER, ShardRowContext::translogUncommittedOperations)).endObject()).startObject(Columns.RETENTION_LEASES.name()).add("primary_term", (DataType)DataTypes.LONG, ShardRowContext::retentionLeasesPrimaryTerm)).add("version", (DataType)DataTypes.LONG, ShardRowContext::retentionLeasesVersion)).startObjectArray("leases", ShardRowContext::retentionLeases).add("id", (DataType)DataTypes.STRING, RetentionLease::id)).add("retaining_seq_no", (DataType)DataTypes.LONG, RetentionLease::retainingSequenceNumber)).add("timestamp", (DataType)DataTypes.TIMESTAMPZ, RetentionLease::timestamp)).add("source", (DataType)DataTypes.STRING, RetentionLease::source)).endObjectArray()).endObject()).setPrimaryKeys(Columns.SCHEMA_NAME, Columns.TABLE_NAME, Columns.ID, Columns.PARTITION_IDENT).withRouting(SysShardsTableInfo::getRouting).build();
    }

    private static void processShardRouting(String localNodeId, Map<String, Map<String, IntIndexedContainer>> routing, ShardRouting shardRouting, ShardId shardId) {
        int id;
        String node;
        String index = shardId.getIndex().getName();
        if (shardRouting == null) {
            node = localNodeId;
            id = UnassignedShard.markUnassigned(shardId.id());
        } else {
            node = shardRouting.currentNodeId();
            id = shardRouting.id();
        }
        Map nodeMap = routing.computeIfAbsent(node, k -> new TreeMap());
        IntIndexedContainer shards = (IntIndexedContainer)nodeMap.get(index);
        if (shards == null) {
            shards = new IntArrayList();
            nodeMap.put(index, shards);
        }
        shards.add(id);
    }

    public static Routing getRouting(ClusterState clusterState, RoutingProvider routingProvider, SessionContext sessionContext) {
        User user;
        String[] concreteIndices = (String[])Arrays.stream(clusterState.metadata().getConcreteAllOpenIndices()).filter(index -> !IndexParts.isDangling(index)).toArray(String[]::new);
        User user2 = user = sessionContext != null ? sessionContext.sessionUser() : null;
        if (user != null) {
            ArrayList<String> accessibleTables = new ArrayList<String>(concreteIndices.length);
            for (String indexName : concreteIndices) {
                String tableName = RelationName.fqnFromIndexName(indexName);
                if (!user.hasAnyPrivilege(Privilege.Clazz.TABLE, tableName)) continue;
                accessibleTables.add(indexName);
            }
            concreteIndices = accessibleTables.toArray(new String[0]);
        }
        TreeMap<String, Map<String, IntIndexedContainer>> locations = new TreeMap<String, Map<String, IntIndexedContainer>>();
        GroupShardsIterator<ShardIterator> groupShardsIterator = clusterState.getRoutingTable().allAssignedShardsGrouped(concreteIndices, true);
        for (ShardIterator shardIt : groupShardsIterator) {
            ShardRouting shardRouting = shardIt.nextOrNull();
            SysShardsTableInfo.processShardRouting(clusterState.getNodes().getLocalNodeId(), locations, shardRouting, shardIt.shardId());
        }
        return new Routing(locations);
    }

    public static class Columns {
        public static final ColumnIdent ID = new ColumnIdent("id");
        static final ColumnIdent SCHEMA_NAME = new ColumnIdent("schema_name");
        public static final ColumnIdent TABLE_NAME = new ColumnIdent("table_name");
        public static final ColumnIdent PARTITION_IDENT = new ColumnIdent("partition_ident");
        static final ColumnIdent NUM_DOCS = new ColumnIdent("num_docs");
        public static final ColumnIdent PRIMARY = new ColumnIdent("primary");
        static final ColumnIdent RELOCATING_NODE = new ColumnIdent("relocating_node");
        public static final ColumnIdent SIZE = new ColumnIdent("size");
        static final ColumnIdent STATE = new ColumnIdent("state");
        static final ColumnIdent ROUTING_STATE = new ColumnIdent("routing_state");
        static final ColumnIdent ORPHAN_PARTITION = new ColumnIdent("orphan_partition");
        static final ColumnIdent RECOVERY = new ColumnIdent("recovery");
        static final ColumnIdent PATH = new ColumnIdent("path");
        static final ColumnIdent BLOB_PATH = new ColumnIdent("blob_path");
        static final ColumnIdent MIN_LUCENE_VERSION = new ColumnIdent("min_lucene_version");
        static final ColumnIdent NODE = new ColumnIdent("node");
        static final ColumnIdent SEQ_NO_STATS = new ColumnIdent("seq_no_stats");
        static final ColumnIdent TRANSLOG_STATS = new ColumnIdent("translog_stats");
        static final ColumnIdent RETENTION_LEASES = new ColumnIdent("retention_leases");
    }

    private static class NestedNullObjectExpression
    implements NestableCollectExpression<UnassignedShard, Object> {
        private NestedNullObjectExpression() {
        }

        @Override
        public void setNextRow(UnassignedShard unassignedShard) {
        }

        @Override
        public Object value() {
            return null;
        }

        @Override
        public NestableInput<?> getChild(String name) {
            return this;
        }
    }
}

