/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.license.LicenseService;
import io.crate.metadata.settings.CrateSettings;
import io.crate.metadata.sys.SysAllocationsTableInfo;
import io.crate.metadata.sys.SysChecksTableInfo;
import io.crate.metadata.sys.SysClusterTableInfo;
import io.crate.metadata.sys.SysHealth;
import io.crate.metadata.sys.SysJobsLogTableInfo;
import io.crate.metadata.sys.SysJobsTableInfo;
import io.crate.metadata.sys.SysMetricsTableInfo;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import io.crate.metadata.sys.SysNodesTableInfo;
import io.crate.metadata.sys.SysOperationsLogTableInfo;
import io.crate.metadata.sys.SysOperationsTableInfo;
import io.crate.metadata.sys.SysRepositoriesTableInfo;
import io.crate.metadata.sys.SysSegmentsTableInfo;
import io.crate.metadata.sys.SysShardsTableInfo;
import io.crate.metadata.sys.SysSnapshotRestoreTableInfo;
import io.crate.metadata.sys.SysSnapshotsTableInfo;
import io.crate.metadata.sys.SysSummitsTableInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class SysSchemaInfo
implements SchemaInfo {
    public static final String NAME = "sys";
    private final Map<String, TableInfo> tableInfos = new HashMap<String, TableInfo>();

    @Inject
    public SysSchemaInfo(ClusterService clusterService, CrateSettings crateSettings, LicenseService licenseService) {
        this.tableInfos.put(SysClusterTableInfo.IDENT.name(), SysClusterTableInfo.of(clusterService, crateSettings, licenseService));
        this.tableInfos.put(SysNodesTableInfo.IDENT.name(), SysNodesTableInfo.create());
        this.tableInfos.put(SysShardsTableInfo.IDENT.name(), SysShardsTableInfo.create());
        Supplier<DiscoveryNode> localNode = clusterService::localNode;
        this.tableInfos.put(SysJobsTableInfo.IDENT.name(), SysJobsTableInfo.create(localNode));
        this.tableInfos.put(SysJobsLogTableInfo.IDENT.name(), SysJobsLogTableInfo.create(localNode));
        this.tableInfos.put(SysOperationsTableInfo.IDENT.name(), SysOperationsTableInfo.create(localNode));
        this.tableInfos.put(SysOperationsLogTableInfo.IDENT.name(), SysOperationsLogTableInfo.create());
        this.tableInfos.put(SysChecksTableInfo.IDENT.name(), SysChecksTableInfo.create());
        this.tableInfos.put(SysNodeChecksTableInfo.IDENT.name(), SysNodeChecksTableInfo.create());
        this.tableInfos.put(SysRepositoriesTableInfo.IDENT.name(), SysRepositoriesTableInfo.create(clusterService.getClusterSettings().maskedSettings()));
        this.tableInfos.put(SysSnapshotsTableInfo.IDENT.name(), SysSnapshotsTableInfo.create());
        this.tableInfos.put(SysSnapshotRestoreTableInfo.IDENT.name(), SysSnapshotRestoreTableInfo.create());
        this.tableInfos.put(SysSummitsTableInfo.IDENT.name(), SysSummitsTableInfo.create());
        this.tableInfos.put(SysAllocationsTableInfo.IDENT.name(), SysAllocationsTableInfo.create());
        this.tableInfos.put(SysHealth.IDENT.name(), SysHealth.create());
        this.tableInfos.put(SysMetricsTableInfo.NAME.name(), SysMetricsTableInfo.create(localNode));
        this.tableInfos.put(SysSegmentsTableInfo.IDENT.name(), SysSegmentsTableInfo.create(clusterService::localNode));
    }

    @Override
    public TableInfo getTableInfo(String name) {
        return this.tableInfos.get(name);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void invalidateTableCache(String tableName) {
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return this.tableInfos.values();
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void update(ClusterChangedEvent event) {
    }

    public void registerSysTable(TableInfo tableInfo) {
        assert (tableInfo.ident().schema().equals(NAME)) : "table is not in sys schema";
        assert (!this.tableInfos.containsKey(tableInfo.ident().name())) : "table already exists";
        this.tableInfos.put(tableInfo.ident().name(), tableInfo);
    }
}

