/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.license.LicenseService;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.settings.CrateSettings;
import io.crate.settings.CrateSetting;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;

public class SysClusterTableInfo {
    public static final RelationName IDENT = new RelationName("sys", "cluster");

    public static SystemTable<Void> of(ClusterService clusterService, CrateSettings crateSettings, LicenseService licenseService) {
        Settings settings = clusterService.getSettings();
        SystemTable.RelationBuilder relBuilder = (SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("id", (DataType)DataTypes.STRING, nothing -> clusterService.state().metadata().clusterUUID())).add("name", (DataType)DataTypes.STRING, nothing -> ClusterName.CLUSTER_NAME_SETTING.get(settings).value())).add("master_node", (DataType)DataTypes.STRING, nothing -> clusterService.state().nodes().getMasterNodeId())).startObject("license", x -> licenseService.currentLicense() == null).add("expiry_date", (DataType)DataTypes.TIMESTAMPZ, x -> licenseService.getExpiryDateInMs())).add("issued_to", (DataType)DataTypes.STRING, x -> licenseService.getIssuedTo())).add("max_nodes", (DataType)DataTypes.INTEGER, x -> licenseService.getMaxNodes())).endObject();
        SystemTable.ObjectBuilder settingsBuilder = (SystemTable.ObjectBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectArrayBuilder)relBuilder.startObject("settings").startObjectArray("logger", SysClusterTableInfo.extractLoggers(crateSettings)).add("name", (DataType)DataTypes.STRING, LoggerEntry::loggerName)).add("level", (DataType)DataTypes.STRING, LoggerEntry::level)).endObjectArray();
        Node<CrateSetting<?>> rootNode = SysClusterTableInfo.toTree(CrateSettings.BUILT_IN_SETTINGS);
        for (Node<CrateSetting<?>> node : rootNode.children) {
            SysClusterTableInfo.addSetting(crateSettings, settingsBuilder, node);
        }
        return ((SystemTable.RelationBuilder)settingsBuilder.endObject()).build();
    }

    private static void addSetting(CrateSettings crateSettings, SystemTable.ObjectBuilder<Void, ? extends SystemTable.Builder<Void>> settingsBuilder, Node<CrateSetting<?>> element) {
        if (element instanceof Leaf) {
            Leaf leaf = (Leaf)element;
            CrateSetting crateSetting = (CrateSetting)leaf.value;
            DataType<?> valueType = ((CrateSetting)leaf.value).dataType();
            settingsBuilder.add(leaf.name, valueType, x -> valueType.implicitCast(crateSetting.setting().get(crateSettings.settings())));
        } else {
            Node<CrateSetting<?>> node = element;
            SystemTable.ObjectBuilder<Void, SystemTable.ObjectBuilder<Void, ? extends SystemTable.Builder<Void>>> objectSetting = settingsBuilder.startObject(node.name);
            for (Node<CrateSetting<?>> node2 : node.children) {
                SysClusterTableInfo.addSetting(crateSettings, objectSetting, node2);
            }
            objectSetting.endObject();
        }
    }

    private static Function<Void, List<LoggerEntry>> extractLoggers(CrateSettings crateSettings) {
        return x -> {
            Settings settings = crateSettings.settings();
            ArrayList<LoggerEntry> loggers = new ArrayList<LoggerEntry>();
            for (String settingName : settings.keySet()) {
                if (!settingName.startsWith("logger.")) continue;
                loggers.add(new LoggerEntry(settingName, settings.get(settingName).toUpperCase(Locale.ENGLISH)));
            }
            return loggers;
        };
    }

    static Node<CrateSetting<?>> toTree(List<CrateSetting<?>> builtInSettings) {
        Node rootNode = new Node("root");
        for (CrateSetting<?> crateSetting : builtInSettings) {
            rootNode.add(crateSetting.path(), crateSetting);
        }
        return rootNode;
    }

    static class Node<T> {
        final String name;
        final ArrayList<Node<T>> children = new ArrayList();

        public Node(String name) {
            this.name = name;
        }

        public void add(List<String> path, T value) {
            switch (path.size()) {
                case 0: {
                    throw new IllegalArgumentException("Path must not be empty");
                }
                case 1: {
                    this.children.add(new Leaf<T>(path.get(0), value));
                    break;
                }
                default: {
                    String valueName = path.get(0);
                    for (Node<T> child : this.children) {
                        if (!child.name.equals(valueName)) continue;
                        child.add(path.subList(1, path.size()), value);
                        return;
                    }
                    Node<T> newChild = new Node<T>(valueName);
                    this.children.add(newChild);
                    newChild.add(path.subList(1, path.size()), value);
                }
            }
        }
    }

    static class Leaf<T>
    extends Node<T> {
        final T value;

        public Leaf(String name, T value) {
            super(name);
            this.value = value;
        }
    }

    public static class LoggerEntry {
        private final String loggerName;
        private final String level;

        public LoggerEntry(String loggerName, String level) {
            this.loggerName = loggerName;
            this.level = level;
        }

        public String loggerName() {
            return this.loggerName;
        }

        public String level() {
            return this.level;
        }
    }
}

