/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.planner.operators.StatementClassifier;
import javax.annotation.concurrent.Immutable;
import org.HdrHistogram.Histogram;

@Immutable
public final class MetricsView {
    private final Histogram histogram;
    private final long sumOfDurations;
    private final long failedCount;
    private final StatementClassifier.Classification classification;

    public MetricsView(Histogram histogram, long sumOfDurations, long failedCount, StatementClassifier.Classification classification) {
        this.histogram = histogram;
        this.sumOfDurations = sumOfDurations;
        this.failedCount = failedCount;
        this.classification = classification;
    }

    public long totalCount() {
        return this.histogram.getTotalCount();
    }

    public double mean() {
        return this.histogram.getMean();
    }

    public double stdDeviation() {
        return this.histogram.getStdDeviation();
    }

    public long maxValue() {
        return this.histogram.getMaxValue();
    }

    public long minValue() {
        long minValue = this.histogram.getMinValue();
        return minValue == Long.MAX_VALUE ? 0L : minValue;
    }

    public long getValueAtPercentile(double percentile) {
        return this.histogram.getValueAtPercentile(percentile);
    }

    public long sumOfDurations() {
        return this.sumOfDurations;
    }

    public long failedCount() {
        return this.failedCount;
    }

    public StatementClassifier.Classification classification() {
        return this.classification;
    }
}

