/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings.session;

import io.crate.action.sql.SessionContext;
import io.crate.common.collections.MapBuilder;
import io.crate.metadata.SearchPath;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingProvider;
import io.crate.protocols.postgres.PostgresWireProtocol;
import io.crate.types.DataTypes;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class SessionSettingRegistry {
    private static final String SEARCH_PATH_KEY = "search_path";
    public static final String HASH_JOIN_KEY = "enable_hashjoin";
    static final String MAX_INDEX_KEYS = "max_index_keys";
    private static final String SERVER_VERSION_NUM = "server_version_num";
    private static final String SERVER_VERSION = "server_version";
    private final Map<String, SessionSetting<?>> settings;

    @Inject
    public SessionSettingRegistry(Set<SessionSettingProvider> sessionSettingProviders) {
        MapBuilder<String, SessionSetting<Object[]>> builder = MapBuilder.treeMapBuilder().put(SEARCH_PATH_KEY, new SessionSetting<SearchPath>(SEARCH_PATH_KEY, objects -> {}, objects -> SearchPath.createSearchPathFrom(SessionSettingRegistry.objectsToStringArray(objects)), SessionContext::setSearchPath, s -> String.join((CharSequence)", ", s.searchPath()), () -> String.join((CharSequence)", ", SearchPath.pathWithPGCatalogAndDoc()), "Sets the schema search order.", DataTypes.STRING)).put(HASH_JOIN_KEY, new SessionSetting<Boolean>(HASH_JOIN_KEY, objects -> {
            if (((Object[])objects).length != 1) {
                throw new IllegalArgumentException("enable_hashjoin should have only one argument.");
            }
        }, objects -> DataTypes.BOOLEAN.implicitCast(objects[0]), SessionContext::setHashJoinEnabled, s -> Boolean.toString(s.hashJoinsEnabled()), () -> String.valueOf(true), "Considers using the Hash Join instead of the Nested Loop Join implementation.", DataTypes.BOOLEAN)).put(MAX_INDEX_KEYS, new SessionSetting<Object[]>(MAX_INDEX_KEYS, objects -> {}, Function.identity(), (s, v) -> {
            throw new UnsupportedOperationException("\"max_index_keys\" cannot be changed.");
        }, s -> String.valueOf(32), () -> String.valueOf(32), "Shows the maximum number of index keys.", DataTypes.INTEGER)).put(SERVER_VERSION_NUM, new SessionSetting<Object[]>(SERVER_VERSION_NUM, objects -> {}, Function.identity(), (s, v) -> {
            throw new UnsupportedOperationException("\"server_version_num\" cannot be changed.");
        }, s -> String.valueOf(PostgresWireProtocol.SERVER_VERSION_NUM), () -> String.valueOf(PostgresWireProtocol.SERVER_VERSION_NUM), "Reports the emulated PostgreSQL version number", DataTypes.INTEGER)).put(SERVER_VERSION, new SessionSetting<Object[]>(SERVER_VERSION, objects -> {}, Function.identity(), (s, v) -> {
            throw new UnsupportedOperationException("\"server_version\" cannot be changed.");
        }, s -> String.valueOf(PostgresWireProtocol.PG_SERVER_VERSION), () -> String.valueOf(PostgresWireProtocol.PG_SERVER_VERSION), "Reports the emulated PostgreSQL version number", DataTypes.STRING));
        for (SessionSettingProvider providers : sessionSettingProviders) {
            for (SessionSetting<?> setting : providers.sessionSettings()) {
                builder.put(setting.name(), setting);
            }
        }
        this.settings = builder.immutableMap();
    }

    public Map<String, SessionSetting<?>> settings() {
        return this.settings;
    }

    private static String[] objectsToStringArray(Object[] objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = DataTypes.STRING.implicitCast(objects[i]);
        }
        return strings;
    }
}

