/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings.session;

import io.crate.action.sql.SessionContext;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.SessionSettings;
import io.crate.types.DataType;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SessionSetting<T> {
    private final String name;
    private final Consumer<Object[]> validator;
    private final Function<Object[], T> converter;
    private final BiConsumer<SessionContext, T> setter;
    private final Function<SessionSettings, String> getter;
    private final Supplier<String> defaultValue;
    private final String description;
    private final DataType<?> type;

    public SessionSetting(String name, Consumer<Object[]> validator, Function<Object[], T> converter, BiConsumer<SessionContext, T> setter, Function<SessionSettings, String> getter, Supplier<String> defaultValue, String description, DataType<?> type) {
        this.name = name;
        this.validator = validator;
        this.converter = converter;
        this.setter = setter;
        this.getter = getter;
        this.defaultValue = defaultValue;
        this.description = description;
        this.type = type;
    }

    public void apply(SessionContext sessionContext, List<Symbol> symbols, Function<? super Symbol, Object> eval) {
        Object[] values = new Object[symbols.size()];
        for (int i = 0; i < symbols.size(); ++i) {
            Symbol symbol = symbols.get(i);
            values[i] = eval.apply(symbol);
        }
        this.validator.accept(values);
        T converted = this.converter.apply(values);
        this.setter.accept(sessionContext, (SessionContext)converted);
    }

    public String getValue(SessionSettings sessionSettings) {
        return this.getter.apply(sessionSettings);
    }

    public String defaultValue() {
        return this.defaultValue.get();
    }

    public String description() {
        return this.description;
    }

    public DataType<?> type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }
}

