/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.metadata.SearchPath;
import io.crate.planner.optimizer.Rule;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class SessionSettings
implements Writeable {
    private final String userName;
    private final SearchPath searchPath;
    private final boolean hashJoinsEnabled;
    private final Set<Class<? extends Rule<?>>> excludedOptimizerRules;

    public SessionSettings(StreamInput in) throws IOException {
        this.userName = in.readString();
        this.searchPath = SearchPath.createSearchPathFrom(in);
        this.hashJoinsEnabled = in.readBoolean();
        this.excludedOptimizerRules = Set.of();
    }

    @VisibleForTesting
    public SessionSettings(String userName, SearchPath searchPath) {
        this(userName, searchPath, true, Set.of());
    }

    public SessionSettings(String userName, SearchPath searchPath, boolean hashJoinsEnabled, Set<Class<? extends Rule<?>>> rules) {
        this.userName = userName;
        this.searchPath = searchPath;
        this.hashJoinsEnabled = hashJoinsEnabled;
        this.excludedOptimizerRules = rules;
    }

    public String userName() {
        return this.userName;
    }

    public String currentSchema() {
        return this.searchPath.currentSchema();
    }

    public SearchPath searchPath() {
        return this.searchPath;
    }

    public boolean hashJoinsEnabled() {
        return this.hashJoinsEnabled;
    }

    public Set<Class<? extends Rule<?>>> excludedOptimizerRules() {
        return this.excludedOptimizerRules;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.userName);
        this.searchPath.writeTo(out);
        out.writeBoolean(this.hashJoinsEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionSettings that = (SessionSettings)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.searchPath, that.searchPath) && Objects.equals(this.hashJoinsEnabled, that.hashJoinsEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.searchPath, this.hashJoinsEnabled);
    }
}

