/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.analyze.NumberOfReplicas;
import io.crate.analyze.TableParameters;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class NumberOfReplicasSetting
extends Setting<Settings> {
    private static final String NAME = TableParameters.stripIndexPrefix("index.number_of_replicas");
    private static final Settings DEFAULT = Settings.builder().put("index.number_of_replicas", 0).put("index.auto_expand_replicas", IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.getDefaultRaw(Settings.EMPTY)).build();

    public NumberOfReplicasSetting() {
        this((Setting.Key)new Setting.SimpleKey(NAME), (Settings s) -> "0-1", NumberOfReplicasSetting::parseValue, new Setting.Property[0]);
    }

    private NumberOfReplicasSetting(Setting.Key key, Function<Settings, String> defaultValue, Function<String, Settings> parser, Setting.Property ... properties) {
        super(key, defaultValue, parser, properties);
    }

    private static Settings parseValue(String val) {
        NumberOfReplicas numberOfReplicas;
        Settings.Builder builder = Settings.builder();
        try {
            Integer numReplicas = NumberOfReplicasSetting.parseInt(val, 0, NAME);
            numberOfReplicas = new NumberOfReplicas(numReplicas);
        }
        catch (NumberFormatException e) {
            numberOfReplicas = new NumberOfReplicas(val);
        }
        builder.put(AutoExpandReplicas.SETTING.getKey(), false);
        builder.put(numberOfReplicas.esSettingKey(), numberOfReplicas.esSettingValue());
        return builder.build();
    }

    @Override
    public Settings getDefault(Settings settings) {
        return DEFAULT;
    }
}

