/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.cluster.gracefulstop.DecommissioningService;
import io.crate.execution.engine.collect.stats.JobsLogService;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.memory.MemoryManagerFactory;
import io.crate.settings.CrateSetting;
import io.crate.statistics.TableStatsService;
import io.crate.types.DataTypes;
import io.crate.udc.service.UDCService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.recovery.RecoverySettings;

public final class CrateSettings
implements ClusterStateListener {
    public static final List<CrateSetting<?>> CRATE_CLUSTER_SETTINGS = List.of(JobsLogService.STATS_ENABLED_SETTING, JobsLogService.STATS_JOBS_LOG_SIZE_SETTING, JobsLogService.STATS_JOBS_LOG_EXPIRATION_SETTING, JobsLogService.STATS_JOBS_LOG_FILTER, JobsLogService.STATS_JOBS_LOG_PERSIST_FILTER, JobsLogService.STATS_OPERATIONS_LOG_SIZE_SETTING, JobsLogService.STATS_OPERATIONS_LOG_EXPIRATION_SETTING, TableStatsService.STATS_SERVICE_REFRESH_INTERVAL_SETTING, ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING, DecommissioningService.DECOMMISSION_INTERNAL_SETTING_GROUP, DecommissioningService.GRACEFUL_STOP_MIN_AVAILABILITY_SETTING, DecommissioningService.GRACEFUL_STOP_TIMEOUT_SETTING, DecommissioningService.GRACEFUL_STOP_FORCE_SETTING, UDCService.UDC_ENABLED_SETTING, UDCService.UDC_URL_SETTING, UDCService.UDC_INITIAL_DELAY_SETTING, UDCService.UDC_INTERVAL_SETTING, MemoryManagerFactory.MEMORY_ALLOCATION_TYPE);
    private static final List<CrateSetting<?>> EXPOSED_ES_SETTINGS = List.of(CrateSetting.of(InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING, DataTypes.STRING), CrateSetting.of(EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING, DataTypes.STRING), CrateSetting.of(EnableAllocationDecider.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING, DataTypes.STRING), CrateSetting.of(ClusterRebalanceAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING, DataTypes.STRING), CrateSetting.of(ConcurrentRebalanceAllocationDecider.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING, DataTypes.INTEGER), CrateSetting.of(ShardsLimitAllocationDecider.CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING, DataTypes.INTEGER), CrateSetting.of(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING, DataTypes.INTEGER), CrateSetting.of(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, DataTypes.INTEGER), HierarchyCircuitBreakerService.JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING, HierarchyCircuitBreakerService.JOBS_LOG_CIRCUIT_BREAKER_OVERHEAD_SETTING, HierarchyCircuitBreakerService.OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING, HierarchyCircuitBreakerService.OPERATIONS_LOG_CIRCUIT_BREAKER_OVERHEAD_SETTING, HierarchyCircuitBreakerService.QUERY_CIRCUIT_BREAKER_LIMIT_SETTING, HierarchyCircuitBreakerService.QUERY_CIRCUIT_BREAKER_OVERHEAD_SETTING, CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_ip", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_id", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_host", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_name", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_ip", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_id", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_host", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_name", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_ip", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_id", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_host", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_name", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING), CrateSetting.of(BalancedShardsAllocator.SHARD_BALANCE_FACTOR_SETTING, DataTypes.FLOAT), CrateSetting.of(BalancedShardsAllocator.INDEX_BALANCE_FACTOR_SETTING, DataTypes.FLOAT), CrateSetting.of(BalancedShardsAllocator.THRESHOLD_SETTING, DataTypes.FLOAT), CrateSetting.of(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, DataTypes.BOOLEAN), CrateSetting.of(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, DataTypes.STRING), CrateSetting.of(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, DataTypes.STRING), CrateSetting.of(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, DataTypes.STRING), CrateSetting.of(DiscoverySettings.PUBLISH_TIMEOUT_SETTING, DataTypes.STRING), CrateSetting.of(GatewayService.RECOVER_AFTER_NODES_SETTING, DataTypes.INTEGER), CrateSetting.of(GatewayService.RECOVER_AFTER_TIME_SETTING, DataTypes.STRING), CrateSetting.of(GatewayService.EXPECTED_NODES_SETTING, DataTypes.INTEGER), CrateSetting.of(RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING, DataTypes.STRING), CrateSetting.of(RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING, DataTypes.STRING), CrateSetting.of(RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING, DataTypes.STRING), CrateSetting.of(RecoverySettings.INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING, DataTypes.STRING), CrateSetting.of(RecoverySettings.INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING, DataTypes.STRING), CrateSetting.of(RecoverySettings.INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING, DataTypes.STRING), CrateSetting.of(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, DataTypes.STRING), CrateSetting.of(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, DataTypes.DOUBLE), CrateSetting.of(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, DataTypes.STRING), CrateSetting.of(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, DataTypes.DOUBLE), CrateSetting.of(HierarchyCircuitBreakerService.TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, DataTypes.STRING), CrateSetting.of(ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE, DataTypes.INTEGER));
    public static final List<CrateSetting<?>> BUILT_IN_SETTINGS = Stream.concat(CRATE_CLUSTER_SETTINGS.stream(), EXPOSED_ES_SETTINGS.stream()).filter(cs -> !cs.getKey().startsWith("crate.internal.")).collect(Collectors.toList());
    private static final List<String> BUILT_IN_SETTING_NAMES = BUILT_IN_SETTINGS.stream().map(CrateSetting::getKey).collect(Collectors.toList());
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Settings initialSettings;
    private volatile Settings settings;

    public static boolean isValidSetting(String name) {
        return CrateSettings.isLoggingSetting(name) || BUILT_IN_SETTING_NAMES.contains(name) || !BUILT_IN_SETTING_NAMES.stream().noneMatch(s -> s.startsWith(name + "."));
    }

    public static List<String> settingNamesByPrefix(String prefix) {
        if (CrateSettings.isLoggingSetting(prefix)) {
            return Collections.singletonList(prefix);
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String key : BUILT_IN_SETTING_NAMES) {
            if (!key.startsWith(prefix)) continue;
            filteredList.add(key);
        }
        return filteredList;
    }

    public static void checkIfRuntimeSetting(String name) {
        for (CrateSetting<?> crateSetting : BUILT_IN_SETTINGS) {
            Setting<?> setting = crateSetting.setting();
            if (!setting.getKey().equals(name) || setting.isDynamic()) continue;
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Setting '%s' cannot be set/reset at runtime", name));
        }
    }

    public static void flattenSettings(Settings.Builder settingsBuilder, String key, Object value) {
        if (value instanceof Map) {
            for (Map.Entry setting : ((Map)value).entrySet()) {
                CrateSettings.flattenSettings(settingsBuilder, String.join((CharSequence)".", key, (CharSequence)setting.getKey()), setting.getValue());
            }
        } else {
            if (value == null) {
                throw new IllegalArgumentException("Cannot set \"" + key + "\" to `null`. Use `RESET [GLOBAL] \"" + key + "\"` to reset a setting to its default value");
            }
            if (value instanceof List) {
                Object values = DataTypes.STRING_ARRAY.sanitizeValue(value);
                settingsBuilder.put(key, String.join((CharSequence)",", (Iterable<? extends CharSequence>)values));
            } else {
                settingsBuilder.put(key, value.toString());
            }
        }
    }

    private static boolean isLoggingSetting(String name) {
        return name.startsWith("logger.");
    }

    @Inject
    public CrateSettings(ClusterService clusterService, Settings settings) {
        Settings.Builder defaultsBuilder = Settings.builder();
        for (CrateSetting<?> builtInSetting : BUILT_IN_SETTINGS) {
            defaultsBuilder.put(builtInSetting.getKey(), builtInSetting.setting().getDefaultRaw(settings));
        }
        this.settings = this.initialSettings = defaultsBuilder.put(settings).build();
        clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            if (!event.state().blocks().disableStatePersistence() && event.metadataChanged()) {
                Settings incomingSetting = event.state().metadata().settings();
                this.settings = Settings.builder().put(this.initialSettings).put(incomingSetting).build();
            }
        }
        catch (Exception ex) {
            this.logger.warn("failed to apply cluster settings", (Throwable)ex);
        }
    }

    public Settings settings() {
        return this.settings;
    }
}

