/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.statistics.ColumnStatsEntry;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;

public class PgStatsTable {
    public static final RelationName NAME = new RelationName("pg_catalog", "pg_stats");

    public static SystemTable<ColumnStatsEntry> create() {
        return ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(NAME).add("schemaname", (DataType)DataTypes.STRING, x -> x.relation().schema())).add("tablename", (DataType)DataTypes.STRING, x -> x.relation().name())).add("attname", (DataType)DataTypes.STRING, x -> x.column().sqlFqn())).add("inherited", (DataType)DataTypes.BOOLEAN, c -> false)).add("null_frac", (DataType)DataTypes.FLOAT, x -> Float.valueOf((float)x.columnStats().nullFraction()))).add("avg_width", (DataType)DataTypes.INTEGER, x -> (int)x.columnStats().averageSizeInBytes())).add("n_distinct", (DataType)DataTypes.FLOAT, x -> Float.valueOf((float)x.columnStats().approxDistinct()))).add("most_common_vals", DataTypes.STRING_ARRAY, x -> DataTypes.STRING_ARRAY.fromAnyArray(x.columnStats().mostCommonValues().values()))).add("most_common_freqs", DataTypes.FLOAT_ARRAY, x -> {
            double[] frequencies = x.columnStats().mostCommonValues().frequencies();
            ArrayList<Float> values = new ArrayList<Float>(frequencies.length);
            for (double frequency : frequencies) {
                values.add(Float.valueOf((float)frequency));
            }
            return values;
        })).add("histogram_bounds", DataTypes.STRING_ARRAY, x -> DataTypes.STRING_ARRAY.fromAnyArray(x.columnStats().histogram()))).add("correlation", (DataType)DataTypes.FLOAT, c -> Float.valueOf(0.0f))).add("most_common_elems", DataTypes.STRING_ARRAY, c -> null)).add("most_common_elem_freqs", new ArrayType<Float>(DataTypes.FLOAT), c -> null)).add("elem_count_histogram", new ArrayType<Float>(DataTypes.FLOAT), c -> null)).build();
    }
}

