/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.common.collections.Lists2;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.protocols.postgres.types.AnyType;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PgProcTable {
    public static final RelationName IDENT = new RelationName("pg_catalog", "pg_proc");

    public static SystemTable<Entry> create() {
        return ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("oid", (DataType)DataTypes.INTEGER, x -> OidHash.functionOid(x.signature))).add("proname", (DataType)DataTypes.STRING, x -> x.signature.getName().name())).add("pronamespace", (DataType)DataTypes.INTEGER, x -> OidHash.schemaOid(x.functionName.schema()))).add("proowner", (DataType)DataTypes.INTEGER, x -> null)).add("prolang", (DataType)DataTypes.INTEGER, x -> null)).add("procost", (DataType)DataTypes.FLOAT, x -> null)).add("prorows", (DataType)DataTypes.FLOAT, x -> Float.valueOf(!x.returnSetType ? 0.0f : 1000.0f))).add("provariadic", (DataType)DataTypes.INTEGER, x -> {
            if (x.signature.getBindingInfo().isVariableArity()) {
                List<TypeSignature> args = x.signature.getArgumentTypes();
                return Entry.pgTypeIdFrom(args.get(args.size() - 1));
            }
            return 0;
        })).add("protransform", (DataType)DataTypes.REGPROC, x -> null)).add("proisagg", (DataType)DataTypes.BOOLEAN, x -> x.signature.getKind() == FunctionType.AGGREGATE)).add("proiswindow", (DataType)DataTypes.BOOLEAN, x -> x.signature.getKind() == FunctionType.WINDOW)).add("prosecdef", (DataType)DataTypes.BOOLEAN, x -> null)).add("proleakproof", (DataType)DataTypes.BOOLEAN, x -> null)).add("proisstrict", (DataType)DataTypes.BOOLEAN, x -> null)).add("proretset", (DataType)DataTypes.BOOLEAN, x -> x.returnSetType)).add("provolatile", (DataType)DataTypes.STRING, x -> null)).add("proparallel", (DataType)DataTypes.STRING, x -> null)).add("pronargs", (DataType)DataTypes.SHORT, x -> (short)x.signature.getArgumentTypes().size())).add("pronargdefaults", (DataType)DataTypes.SHORT, x -> null)).add("prorettype", (DataType)DataTypes.INTEGER, x -> x.returnTypeId)).add("proargtypes", (DataType)DataTypes.OIDVECTOR, x -> Lists2.map(x.signature.getArgumentTypes(), Entry::pgTypeIdFrom))).add("proallargtypes", DataTypes.INTEGER_ARRAY, x -> null)).add("proargmodes", DataTypes.STRING_ARRAY, x -> {
            if (!x.signature.getBindingInfo().isVariableArity()) {
                return null;
            }
            int numOfArgs = x.signature.getArgumentTypes().size();
            ArrayList<String> modes = new ArrayList<String>(numOfArgs);
            for (int i = 0; i < numOfArgs - 1; ++i) {
                modes.add("i");
            }
            modes.add("v");
            return modes;
        })).add("proargnames", DataTypes.STRING_ARRAY, x -> null)).startObjectArray("proargdefaults", x -> null).endObjectArray().add("protrftypes", DataTypes.INTEGER_ARRAY, x -> null)).add("prosrc", (DataType)DataTypes.STRING, x -> x.functionName.name())).add("probin", (DataType)DataTypes.STRING, x -> null)).add("proconfig", DataTypes.STRING_ARRAY, x -> null)).add("proacl", DataTypes.STRING_ARRAY, x -> null)).build();
    }

    public static final class Entry {
        private static final Set<String> SET_TYPES = Set.of("array", "record");
        final Signature signature;
        final FunctionName functionName;
        final int returnTypeId;
        final boolean returnSetType;

        public static Entry of(Signature signature) {
            return new Entry(signature.getName(), signature);
        }

        private Entry(FunctionName functionName, Signature signature) {
            this.signature = signature;
            this.functionName = functionName;
            TypeSignature returnTypeSignature = signature.getReturnType();
            this.returnTypeId = Entry.pgTypeIdFrom(returnTypeSignature);
            this.returnSetType = SET_TYPES.contains(returnTypeSignature.getBaseTypeName());
        }

        static int pgTypeIdFrom(TypeSignature typeSignature) {
            DataType<?> crateDataType = DataTypes.ofNameOrNull(typeSignature.getBaseTypeName());
            if (crateDataType == null) {
                if ("array".equalsIgnoreCase(typeSignature.getBaseTypeName())) {
                    return PGArray.ANY_ARRAY.oid();
                }
                return AnyType.INSTANCE.oid();
            }
            return PGTypes.get(crateDataType).oid();
        }
    }
}

