/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.analyze.user.Privilege;
import io.crate.execution.engine.collect.sources.InformationSchemaIterables;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.information.ColumnContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.pgcatalog.PgAmTable;
import io.crate.metadata.pgcatalog.PgAttrDefTable;
import io.crate.metadata.pgcatalog.PgAttributeTable;
import io.crate.metadata.pgcatalog.PgCatalogSchemaInfo;
import io.crate.metadata.pgcatalog.PgClassTable;
import io.crate.metadata.pgcatalog.PgConstraintTable;
import io.crate.metadata.pgcatalog.PgDatabaseTable;
import io.crate.metadata.pgcatalog.PgDescriptionTable;
import io.crate.metadata.pgcatalog.PgEnumTable;
import io.crate.metadata.pgcatalog.PgIndexTable;
import io.crate.metadata.pgcatalog.PgNamespaceTable;
import io.crate.metadata.pgcatalog.PgProcTable;
import io.crate.metadata.pgcatalog.PgRangeTable;
import io.crate.metadata.pgcatalog.PgRolesTable;
import io.crate.metadata.pgcatalog.PgSettingsTable;
import io.crate.metadata.pgcatalog.PgStatsTable;
import io.crate.metadata.pgcatalog.PgTypeTable;
import io.crate.metadata.settings.session.NamedSessionSetting;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.metadata.table.ConstraintInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.protocols.postgres.types.PGType;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.statistics.ColumnStatsEntry;
import io.crate.statistics.TableStats;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.inject.Inject;

public class PgCatalogTableDefinitions {
    private final Map<RelationName, StaticTableDefinition<?>> tableDefinitions = new HashMap(9);

    @Inject
    public PgCatalogTableDefinitions(InformationSchemaIterables informationSchemaIterables, TableStats tableStats, PgCatalogSchemaInfo pgCatalogSchemaInfo, SessionSettingRegistry sessionSettingRegistry) {
        this.tableDefinitions.put(PgStatsTable.NAME, new StaticTableDefinition<ColumnStatsEntry>(tableStats::statsEntries, (user, t) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, t.relation().fqn()), PgStatsTable.create().expressions()));
        this.tableDefinitions.put(PgTypeTable.IDENT, new StaticTableDefinition<PGType>(() -> CompletableFuture.completedFuture(PGTypes.pgTypes()), PgTypeTable.create().expressions(), false));
        this.tableDefinitions.put(PgClassTable.IDENT, new StaticTableDefinition<PgClassTable.Entry>(informationSchemaIterables::pgClasses, (user, t) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, t.ident.fqn()) || user.hasAnyPrivilege(Privilege.Clazz.VIEW, t.ident.fqn()), pgCatalogSchemaInfo.pgClassTable().expressions()));
        this.tableDefinitions.put(PgProcTable.IDENT, new StaticTableDefinition<PgProcTable.Entry>(informationSchemaIterables::pgProc, (user, f) -> user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, f.functionName.schema()), PgProcTable.create().expressions()));
        this.tableDefinitions.put(PgDatabaseTable.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.singletonList(null)), PgDatabaseTable.create().expressions(), false));
        this.tableDefinitions.put(PgNamespaceTable.IDENT, new StaticTableDefinition<SchemaInfo>(informationSchemaIterables::schemas, (user, s) -> user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, s.name()), PgNamespaceTable.create().expressions()));
        this.tableDefinitions.put(PgAttrDefTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgAttrDefTable.create().expressions(), false));
        this.tableDefinitions.put(PgAttributeTable.IDENT, new StaticTableDefinition<ColumnContext>(informationSchemaIterables::columns, (user, c) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, c.tableInfo.ident().fqn()) || user.hasAnyPrivilege(Privilege.Clazz.VIEW, c.tableInfo.ident().fqn()), PgAttributeTable.create().expressions()));
        this.tableDefinitions.put(PgIndexTable.IDENT, new StaticTableDefinition<PgIndexTable.Entry>(() -> CompletableFuture.completedFuture(informationSchemaIterables.pgIndices()), PgIndexTable.create().expressions(), false));
        this.tableDefinitions.put(PgConstraintTable.IDENT, new StaticTableDefinition<ConstraintInfo>(informationSchemaIterables::constraints, (user, t) -> user.hasAnyPrivilege(Privilege.Clazz.TABLE, t.relationName().fqn()), PgConstraintTable.create().expressions()));
        this.tableDefinitions.put(PgDescriptionTable.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgDescriptionTable.create().expressions(), false));
        this.tableDefinitions.put(PgRangeTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgRangeTable.create().expressions(), false));
        this.tableDefinitions.put(PgEnumTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgEnumTable.create().expressions(), false));
        this.tableDefinitions.put(PgRolesTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgRolesTable.create().expressions(), false));
        this.tableDefinitions.put(PgAmTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgAmTable.create().expressions(), false));
        Iterable sessionSettings = () -> sessionSettingRegistry.settings().entrySet().stream().map(s -> new NamedSessionSetting((String)s.getKey(), (SessionSetting)s.getValue())).iterator();
        this.tableDefinitions.put(PgSettingsTable.IDENT, new StaticTableDefinition<NamedSessionSetting>(() -> sessionSettings, PgSettingsTable.create().expressions(), (txnCtx, settingInfo) -> settingInfo.resolveValue((TransactionContext)txnCtx)));
    }

    public StaticTableDefinition<?> get(RelationName relationName) {
        return this.tableDefinitions.get(relationName);
    }
}

