/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.SystemTable;
import io.crate.metadata.pgcatalog.PgAmTable;
import io.crate.metadata.pgcatalog.PgAttrDefTable;
import io.crate.metadata.pgcatalog.PgAttributeTable;
import io.crate.metadata.pgcatalog.PgClassTable;
import io.crate.metadata.pgcatalog.PgConstraintTable;
import io.crate.metadata.pgcatalog.PgDatabaseTable;
import io.crate.metadata.pgcatalog.PgDescriptionTable;
import io.crate.metadata.pgcatalog.PgEnumTable;
import io.crate.metadata.pgcatalog.PgIndexTable;
import io.crate.metadata.pgcatalog.PgNamespaceTable;
import io.crate.metadata.pgcatalog.PgProcTable;
import io.crate.metadata.pgcatalog.PgRangeTable;
import io.crate.metadata.pgcatalog.PgRolesTable;
import io.crate.metadata.pgcatalog.PgSettingsTable;
import io.crate.metadata.pgcatalog.PgStatsTable;
import io.crate.metadata.pgcatalog.PgTypeTable;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.statistics.TableStats;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class PgCatalogSchemaInfo
implements SchemaInfo {
    public static final String NAME = "pg_catalog";
    private final Map<String, TableInfo> tableInfoMap;
    private final UserDefinedFunctionService udfService;
    private final SystemTable<PgClassTable.Entry> pgClassTable;

    @Inject
    public PgCatalogSchemaInfo(UserDefinedFunctionService udfService, TableStats tableStats) {
        this.udfService = udfService;
        this.pgClassTable = PgClassTable.create(tableStats);
        this.tableInfoMap = Map.ofEntries(Map.entry(PgStatsTable.NAME.name(), PgStatsTable.create()), Map.entry(PgTypeTable.IDENT.name(), PgTypeTable.create()), Map.entry(PgClassTable.IDENT.name(), this.pgClassTable), Map.entry(PgNamespaceTable.IDENT.name(), PgNamespaceTable.create()), Map.entry(PgAttrDefTable.IDENT.name(), PgAttrDefTable.create()), Map.entry(PgAttributeTable.IDENT.name(), PgAttributeTable.create()), Map.entry(PgIndexTable.IDENT.name(), PgIndexTable.create()), Map.entry(PgConstraintTable.IDENT.name(), PgConstraintTable.create()), Map.entry(PgDatabaseTable.NAME.name(), PgDatabaseTable.create()), Map.entry(PgDescriptionTable.NAME.name(), PgDescriptionTable.create()), Map.entry(PgSettingsTable.IDENT.name(), PgSettingsTable.create()), Map.entry(PgProcTable.IDENT.name(), PgProcTable.create()), Map.entry(PgRangeTable.IDENT.name(), PgRangeTable.create()), Map.entry(PgEnumTable.IDENT.name(), PgEnumTable.create()), Map.entry(PgRolesTable.IDENT.name(), PgRolesTable.create()), Map.entry(PgAmTable.IDENT.name(), PgAmTable.create()));
    }

    SystemTable<PgClassTable.Entry> pgClassTable() {
        return this.pgClassTable;
    }

    @Override
    @Nullable
    public TableInfo getTableInfo(String name) {
        return this.tableInfoMap.get(name);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void invalidateTableCache(String tableName) {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return this.tableInfoMap.values();
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return Collections.emptyList();
    }

    @Override
    public void update(ClusterChangedEvent event) {
        assert (event.metadataChanged()) : "metadataChanged must be true if update is called";
        Metadata newMetadata = event.state().metadata();
        UserDefinedFunctionsMetadata udfMetadata = (UserDefinedFunctionsMetadata)newMetadata.custom("user_defined_functions");
        if (udfMetadata != null) {
            this.udfService.updateImplementations(NAME, udfMetadata.functionsMetadata().stream().filter(f -> NAME.equals(f.schema())));
        }
    }
}

